{ *********************************************************************** }
{                                                                         }
{ Translated Header File                                                  }
{ Part of the Delphi Visual Component Library                             }
{                                                                         }
{ Original Header File Copyright (c) 1985-2004 Microsoft Corporation      }
{  All Rights Reserved.                                                   }
{                                                                         }
{ Translation Copyright (c) 1995-2004 Borland Software Corporation        }
{                                                                         }
{ *********************************************************************** }

unit Borland.Vcl.WinInet platform;

{$WEAKPACKAGEUNIT}

interface

uses
  System.Text, System.Runtime.InteropServices, Windows;

{ Contains manifests, functions, types and prototypes for
  Microsoft Windows Internet Extensions }


{ internet types }

type
  HINTERNET = IntPtr;

  INTERNET_PORT = Word;

{ Internet APIs }

{ manifests }

const
  INTERNET_INVALID_PORT_NUMBER = 0;                 { use the protocol-specific default }
  INTERNET_DEFAULT_FTP_PORT = 21;                   { default for FTP servers }
  INTERNET_DEFAULT_GOPHER_PORT = 70;                {    "     "  gopher " }
  INTERNET_DEFAULT_HTTP_PORT = 80;                  {    "     "  HTTP   " }
  INTERNET_DEFAULT_HTTPS_PORT = 443;                {    "     "  HTTPS  " }
  INTERNET_DEFAULT_SOCKS_PORT = 1080;               { default for SOCKS firewall servers.}

  MAX_CACHE_ENTRY_INFO_SIZE = 4096;


{ maximum field lengths (arbitrary) }

  INTERNET_MAX_HOST_NAME_LENGTH = 256;
  INTERNET_MAX_USER_NAME_LENGTH = 128;
  INTERNET_MAX_PASSWORD_LENGTH = 128;
  INTERNET_MAX_PORT_NUMBER_LENGTH = 5;              { INTERNET_PORT is unsigned short }
  INTERNET_MAX_PORT_NUMBER_VALUE = 65535;           { maximum unsigned short value }
  INTERNET_MAX_PATH_LENGTH = 2048;
  INTERNET_MAX_SCHEME_LENGTH = 32;                   { longest protocol name length }
  INTERNET_MAX_PROTOCOL_NAME = 'gopher';            { longest protocol name }
  INTERNET_MAX_URL_LENGTH = ((SizeOf(INTERNET_MAX_PROTOCOL_NAME) - 1)
                            + SizeOf('://')
                            + INTERNET_MAX_PATH_LENGTH);

{ values returned by InternetQueryOption with INTERNET_OPTION_KEEP_CONNECTION: }

  INTERNET_KEEP_ALIVE_UNKNOWN = -1;
  INTERNET_KEEP_ALIVE_ENABLED = 1;
  INTERNET_KEEP_ALIVE_DISABLED = 0;

{ flags returned by InternetQueryOption with INTERNET_OPTION_REQUEST_FLAGS }

  INTERNET_REQFLAG_FROM_CACHE   = $00000001;
  INTERNET_REQFLAG_ASYNC        = $00000002;
  INTERNET_REQFLAG_VIA_PROXY    = $00000004;  { request was made via a proxy }
  INTERNET_REQFLAG_NO_HEADERS   = $00000008;  { orginal response contained no headers }
  INTERNET_REQFLAG_PASSIVE      = $00000010;  { FTP: passive-mode connection }
  INTERNET_REQFLAG_CACHE_WRITE_DISABLED = $00000040;  { HTTPS: this request not cacheable }

{ flags common to open functions (not InternetOpen): }

  INTERNET_FLAG_RELOAD = $80000000;                 { retrieve the original item }

{ flags for InternetOpenUrl: }

  INTERNET_FLAG_RAW_DATA = $40000000;               { receive the item as raw data }
  INTERNET_FLAG_EXISTING_CONNECT = $20000000;       { do not create new connection object }

{ flags for InternetOpen: }

  INTERNET_FLAG_ASYNC = $10000000;                  { this request is asynchronous (where supported) }

{ protocol-specific flags: }

  INTERNET_FLAG_PASSIVE = $08000000;                { used for FTP connections }

{ additional cache flags }

  INTERNET_FLAG_NO_CACHE_WRITE        = $04000000;  { don't write this item to the cache }
  INTERNET_FLAG_DONT_CACHE            = INTERNET_FLAG_NO_CACHE_WRITE;
  INTERNET_FLAG_MAKE_PERSISTENT       = $02000000;  { make this item persistent in cache }
  INTERNET_FLAG_FROM_CACHE            = $01000000;  { use offline semantics }
  INTERNET_FLAG_OFFLINE               = $01000000;  { use offline semantics }

{ additional flags }

  INTERNET_FLAG_SECURE                = $00800000;  { use PCT/SSL if applicable (HTTP) }
  INTERNET_FLAG_KEEP_CONNECTION       = $00400000;  { use keep-alive semantics }
  INTERNET_FLAG_NO_AUTO_REDIRECT      = $00200000;  { don't handle redirections automatically }
  INTERNET_FLAG_READ_PREFETCH         = $00100000;  { do background read prefetch }
  INTERNET_FLAG_NO_COOKIES            = $00080000;  { no automatic cookie handling }
  INTERNET_FLAG_NO_AUTH               = $00040000;  { no automatic authentication handling }
  INTERNET_FLAG_CACHE_IF_NET_FAIL     = $00010000;  { return cache file if net request fails }

{ Security Ignore Flags, Allow HttpOpenRequest to overide
  Secure Channel (SSL/PCT) failures of the following types. }

  INTERNET_FLAG_IGNORE_CERT_CN_INVALID        = $00001000; { bad common name in X509 Cert. }
  INTERNET_FLAG_IGNORE_CERT_DATE_INVALID      = $00002000; { expired X509 Cert. }
  INTERNET_FLAG_IGNORE_REDIRECT_TO_HTTPS      = $00004000; { ex: http:// to https:// }
  INTERNET_FLAG_IGNORE_REDIRECT_TO_HTTP       = $00008000; { ex: https:// to http:// }

//
// more caching flags
//

  INTERNET_FLAG_RESYNCHRONIZE     = $00000800;  // asking wininet to update an item if it is newer
  INTERNET_FLAG_HYPERLINK         = $00000400;  // asking wininet to do hyperlinking semantic which works right for scripts
  INTERNET_FLAG_NO_UI             = $00000200;  // no cookie popup
  INTERNET_FLAG_PRAGMA_NOCACHE    = $00000100;  // asking wininet to add "pragma: no-cache"
  INTERNET_FLAG_CACHE_ASYNC       = $00000080;  // ok to perform lazy cache-write
  INTERNET_FLAG_FORMS_SUBMIT      = $00000040;  // this is a forms submit
  INTERNET_FLAG_NEED_FILE         = $00000010;  // need a file for this request
  INTERNET_FLAG_MUST_CACHE_REQUEST = INTERNET_FLAG_NEED_FILE;

{ FTP }

{ manifests }
const
{ flags for FTP }
  FTP_TRANSFER_TYPE_UNKNOWN   = $00000000;
  FTP_TRANSFER_TYPE_ASCII     = $00000001;
  FTP_TRANSFER_TYPE_BINARY    = $00000002;

  FTP_TRANSFER_TYPE_MASK      = FTP_TRANSFER_TYPE_ASCII or
                                FTP_TRANSFER_TYPE_BINARY;

  INTERNET_FLAG_TRANSFER_ASCII        = FTP_TRANSFER_TYPE_ASCII;
  INTERNET_FLAG_TRANSFER_BINARY       = FTP_TRANSFER_TYPE_BINARY;

{ flags field masks }

  SECURITY_INTERNET_MASK      = INTERNET_FLAG_IGNORE_CERT_CN_INVALID or
                                INTERNET_FLAG_IGNORE_CERT_DATE_INVALID or
                                INTERNET_FLAG_IGNORE_REDIRECT_TO_HTTPS or
                                INTERNET_FLAG_IGNORE_REDIRECT_TO_HTTP;

  SECURITY_SET_MASK           = SECURITY_INTERNET_MASK;

  INTERNET_FLAGS_MASK         = INTERNET_FLAG_RELOAD              or
                                INTERNET_FLAG_RAW_DATA            or
                                INTERNET_FLAG_EXISTING_CONNECT    or
                                INTERNET_FLAG_ASYNC               or
                                INTERNET_FLAG_PASSIVE             or
                                INTERNET_FLAG_NO_CACHE_WRITE      or
                                INTERNET_FLAG_MAKE_PERSISTENT     or
                                INTERNET_FLAG_FROM_CACHE          or
                                INTERNET_FLAG_SECURE              or
                                INTERNET_FLAG_KEEP_CONNECTION     or
                                INTERNET_FLAG_NO_AUTO_REDIRECT    or
                                INTERNET_FLAG_READ_PREFETCH       or
                                INTERNET_FLAG_NO_COOKIES          or
                                INTERNET_FLAG_NO_AUTH             or
                                INTERNET_FLAG_CACHE_IF_NET_FAIL   or
                                SECURITY_INTERNET_MASK            or
                                INTERNET_FLAG_RESYNCHRONIZE       or
                                INTERNET_FLAG_HYPERLINK           or
                                INTERNET_FLAG_NO_UI               or
                                INTERNET_FLAG_PRAGMA_NOCACHE      or
                                INTERNET_FLAG_CACHE_ASYNC         or
                                INTERNET_FLAG_FORMS_SUBMIT        or
                                INTERNET_FLAG_NEED_FILE           or
                                INTERNET_FLAG_TRANSFER_BINARY     or
                                INTERNET_FLAG_TRANSFER_ASCII;

  INTERNET_ERROR_MASK_INSERT_CDROM = $1;

  INTERNET_OPTIONS_MASK       =  not INTERNET_FLAGS_MASK;

//
// common per-API flags (new APIs)
//

  WININET_API_FLAG_ASYNC          = $00000001;  // force async operation
  WININET_API_FLAG_SYNC           = $00000004;  // force sync operation
  WININET_API_FLAG_USE_CONTEXT    = $00000008;  // use value supplied in dwContext (even if 0)

{ INTERNET_NO_CALLBACK - if this value is presented as the dwContext parameter }
{ then no call-backs will be made for that API }

  INTERNET_NO_CALLBACK = 0;

{ structures/types }

type
  TInternetScheme = Integer;
const
  INTERNET_SCHEME_PARTIAL = -2;
  INTERNET_SCHEME_UNKNOWN = -1;
  INTERNET_SCHEME_DEFAULT = 0;
  INTERNET_SCHEME_FTP = 1;
  INTERNET_SCHEME_GOPHER = 2;
  INTERNET_SCHEME_HTTP = 3;
  INTERNET_SCHEME_HTTPS = 4;
  INTERNET_SCHEME_FILE = 5;
  INTERNET_SCHEME_NEWS = 6;
  INTERNET_SCHEME_MAILTO = 7;
  INTERNET_SCHEME_FIRST = INTERNET_SCHEME_FTP;
  INTERNET_SCHEME_LAST = INTERNET_SCHEME_MAILTO;

{ TInternetAsyncResult - this structure is returned to the application via }
{ the callback with INTERNET_STATUS_REQUEST_COMPLETE. It is not sufficient to }
{ just return the result of the async operation. If the API failed then the }
{ app cannot call GetLastError because the thread context will be incorrect. }
{ Both the value returned by the async API and any resultant error code are }
{ made available. The app need not check dwError if dwResult indicates that }
{ the API succeeded (in this case dwError will be ERROR_SUCCESS) }

type
  TInternetAsyncResult = packed record
    dwResult: DWORD; { the HINTERNET, DWORD or BOOL return code from an async API }
    dwError: DWORD; { dwError - the error code if the API failed }
  end;

  TInternetPrefetchStatus = packed record
    dwStatus: DWORD;  { dwStatus - status of download. See INTERNET_PREFETCH_ flags }
    dwSize: DWORD;    { dwSize - size of file downloaded so far }
  end;

const
{ INTERNET_PREFETCH_STATUS - dwStatus values }
  INTERNET_PREFETCH_PROGRESS      = 0;
  INTERNET_PREFETCH_COMPLETE      = 1;
  INTERNET_PREFETCH_ABORTED       = 2;

type
{ TInternetProxyInfo - structure supplied with INTERNET_OPTION_PROXY to get/ }
{ set proxy information on a InternetOpen handle }
  [StructLayout(LayoutKind.Sequential)]
  INTERNET_PROXY_INFO = record
    dwAccessType: DWORD;      { dwAccessType - INTERNET_OPEN_TYPE_DIRECT, INTERNET_OPEN_TYPE_PROXY, or }
    [MarshalAs(UnmanagedType.LPTStr)]
    lpszProxy: string;        { lpszProxy - proxy server list }
    [MarshalAs(UnmanagedType.LPTStr)]
    lpszProxyBypass: string;  { lpszProxyBypass - proxy bypass list }
  end;
  TInternetProxyInfo = INTERNET_PROXY_INFO;

{ INTERNET_VERSION_INFO - version information returned via }
{ InternetQueryOption(..., INTERNET_OPTION_VERSION, ...) }

  [StructLayout(LayoutKind.Sequential)]
  INTERNET_VERSION_INFO = record
    dwMajorVersion: DWORD;
    dwMinorVersion: DWORD;
  end;
  TInternetVersionInfo = INTERNET_VERSION_INFO;

{ HTTP_VERSION_INFO - query or set global HTTP version (1.0 or 1.1) }
  [StructLayout(LayoutKind.Sequential)]
  HTTP_VERSION_INFO = record
    dwMajorVersion: DWORD;
    dwMinorVersion: DWORD;
  end;
  THttpVersionInfo = HTTP_VERSION_INFO;

{ INTERNET_CONNECTED_INFO - information used to set the global connected state }

  [StructLayout(LayoutKind.Sequential)]
  INTERNET_CONNECTED_INFO = record
      dwConnectedState: DWORD;     {dwConnectedState - new connected/disconnected state.}
      dwFlags: DWORD;              {dwFlags - flags controlling connected->disconnected (or disconnected-> }
                                   {connected) transition. See below}
  end;
  TInternetConnectedInfo = INTERNET_CONNECTED_INFO;

{ flags for INTERNET_CONNECTED_INFO dwFlags }

{ ISO_FORCE_DISCONNECTED - if set when putting Wininet into disconnected mode, }
{ all outstanding requests will be aborted with a cancelled error }

const
  ISO_FORCE_DISCONNECTED  = $00000001;

{ URL_COMPONENTS - the constituent parts of an URL. Used in InternetCrackUrl }
{ and InternetCreateUrl }

{ For InternetCrackUrl, if a pointer field and its corresponding length field }
{ are both 0 then that component is not returned; If the pointer field is NULL }
{ but the length field is not zero, then both the pointer and length fields are }
{ returned; if both pointer and corresponding length fields are non-zero then }
{ the pointer field points to a buffer where the component is copied. The }
{ component may be un-escaped, depending on dwFlags }

{ For InternetCreateUrl, the pointer fields should be nil if the component }
{ is not required. If the corresponding length field is zero then the pointer }
{ field is the address of a zero-terminated string. If the length field is not }
{ zero then it is the string length of the corresponding pointer field }

type
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Auto)]
  URL_COMPONENTS = record
    dwStructSize: DWORD;        { size of this structure. Used in version check }
    [MarshalAs(UnmanagedType.LPTStr)]
    lpszScheme: string;         { pointer to scheme name }
    dwSchemeLength: DWORD;      { length of scheme name }
    nScheme: TInternetScheme;   { enumerated scheme type (if known) }
    [MarshalAs(UnmanagedType.LPTStr)]
    lpszHostName: string;       { pointer to host name }
    dwHostNameLength: DWORD;    { length of host name }
    nPort: INTERNET_PORT;       { converted port number }
    pad: WORD;                  { force correct allignment regardless of comp. flags}
    [MarshalAs(UnmanagedType.LPTStr)]
    lpszUserName: string;       { pointer to user name }
    dwUserNameLength: DWORD;    { length of user name }
    [MarshalAs(UnmanagedType.LPTStr)]
    lpszPassword: string;       { pointer to password }
    dwPasswordLength: DWORD;    { length of password }
    [MarshalAs(UnmanagedType.LPTStr)]
    lpszUrlPath: string;        { pointer to URL-path }
    dwUrlPathLength: DWORD;     { length of URL-path }
    [MarshalAs(UnmanagedType.LPTStr)]
    lpszExtraInfo: string;      { pointer to extra information (e.g. ?foo or #foo) }
    dwExtraInfoLength: DWORD;   { length of extra information }
  end;
  TURLComponents = URL_COMPONENTS;

{ TInternetCertificateInfo lpBuffer - contains the certificate returned from
  the server }

  [StructLayout(LayoutKind.Sequential)]
  INTERNET_CERTIFICATE_INFO = record
    ftExpiry: TFileTime;             { ftExpiry - date the certificate expires. }
    ftStart: TFileTime;              { ftStart - date the certificate becomes valid. }
    [MarshalAs(UnmanagedType.LPTStr)]
    lpszSubjectInfo: string;        { lpszSubjectInfo - the name of organization, site, and server }
                                    {   the cert. was issued for. }
    [MarshalAs(UnmanagedType.LPTStr)]
    lpszIssuerInfo: string;         { lpszIssuerInfo - the name of orgainzation, site, and server }
                                    {   the cert was issues by. }
    [MarshalAs(UnmanagedType.LPTStr)]
    lpszProtocolName: string;       { lpszProtocolName - the name of the protocol used to provide the secure }
                                    {   connection. }
    [MarshalAs(UnmanagedType.LPTStr)]
    lpszSignatureAlgName: string;   { lpszSignatureAlgName - the name of the algorithm used for signing }
                                    {  the certificate. }
    [MarshalAs(UnmanagedType.LPTStr)]
    lpszEncryptionAlgName: string;  { lpszEncryptionAlgName - the name of the algorithm used for }
                                    {  doing encryption over the secure channel (SSL/PCT) connection. }
    dwKeySize: DWORD;               { dwKeySize - size of the key. }
  end;
  TInternetCertificateInfo = INTERNET_CERTIFICATE_INFO;

{ INTERNET_BUFFERS - combines headers and data. May be chained for e.g. file }
{ upload or scatter/gather operations. For chunked read/write, lpcszHeader }
{ contains the chunked-ext }
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Auto)]
  INTERNET_BUFFERS = record
    dwStructSize: DWORD;      { used for API versioning. Set to sizeof(INTERNET_BUFFERS) }
    Next: IntPtr;             { chain of buffers }
    lpcszHeader: IntPtr;      { Pointer to headers (may be NULL) }
    dwHeadersLength: DWORD;   { length of headers if not NULL }
    dwHeadersTotal: DWORD;    { size of headers if not enough buffer }
    lpvBuffer: IntPtr;        { Pointer to data buffer (may be NULL) }
    dwBufferLength: DWORD;    { length of data buffer if not NULL }
    dwBufferTotal: DWORD;     { total size of chunk, or content-length if not chunked }
    dwOffsetLow: DWORD;       { used for read-ranges (only used in HttpSendRequest2) }
    dwOffsetHigh: DWORD;
  end;
  TInternetBuffers = INTERNET_BUFFERS;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Ansi)]
  INTERNET_BUFFERSA = record
    dwStructSize: DWORD;      { used for API versioning. Set to sizeof(INTERNET_BUFFERS) }
    Next: IntPtr;             { chain of buffers }
    lpcszHeader: IntPtr;      { Pointer to headers (may be NULL) }
    dwHeadersLength: DWORD;   { length of headers if not NULL }
    dwHeadersTotal: DWORD;    { size of headers if not enough buffer }
    lpvBuffer: IntPtr;        { Pointer to data buffer (may be NULL) }
    dwBufferLength: DWORD;    { length of data buffer if not NULL }
    dwBufferTotal: DWORD;     { total size of chunk, or content-length if not chunked }
    dwOffsetLow: DWORD;       { used for read-ranges (only used in HttpSendRequest2) }
    dwOffsetHigh: DWORD;
  end;
  TInternetBuffersA = INTERNET_BUFFERSA;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Unicode)]
  INTERNET_BUFFERSW = record
    dwStructSize: DWORD;      { used for API versioning. Set to sizeof(INTERNET_BUFFERS) }
    Next: IntPtr;             { chain of buffers }
    lpcszHeader: IntPtr;      { Pointer to headers (may be NULL) }
    dwHeadersLength: DWORD;   { length of headers if not NULL }
    dwHeadersTotal: DWORD;    { size of headers if not enough buffer }
    lpvBuffer: IntPtr;        { Pointer to data buffer (may be NULL) }
    dwBufferLength: DWORD;    { length of data buffer if not NULL }
    dwBufferTotal: DWORD;     { total size of chunk, or content-length if not chunked }
    dwOffsetLow: DWORD;       { used for read-ranges (only used in HttpSendRequest2) }
    dwOffsetHigh: DWORD;
  end;
  TInternetBuffersW = INTERNET_BUFFERSW;

{ prototypes }

function InternetTimeFromSystemTime(const pst: TSystemTime;
  dwRFC: DWORD; lpszTime: StringBuilder; cbTime: DWORD): BOOL;
function InternetTimeFromSystemTimeA(const pst: TSystemTime;
  dwRFC: DWORD; lpszTime: StringBuilder; cbTime: DWORD): BOOL;
function InternetTimeFromSystemTimeW(const pst: TSystemTime;
  dwRFC: DWORD; lpszTime: StringBuilder; cbTime: DWORD): BOOL;

const
{ constants for InternetTimeFromSystemTime }
  INTERNET_RFC1123_FORMAT         = 0;
  INTERNET_RFC1123_BUFSIZE        = 30;

function InternetCrackUrl(lpszUrl: string; dwUrlLength, dwFlags: DWORD;
  var lpUrlComponents: TURLComponents): BOOL;
function InternetCrackUrlA(lpszUrl: string; dwUrlLength, dwFlags: DWORD;
  var lpUrlComponents: TURLComponents): BOOL;
function InternetCrackUrlW(lpszUrl: string; dwUrlLength, dwFlags: DWORD;
  var lpUrlComponents: TURLComponents): BOOL;

function InternetCreateUrl(const lpUrlComponents: TURLComponents;
  dwFlags: DWORD; lpszUrl: StringBuilder; var dwUrlLength: DWORD): BOOL;
function InternetCreateUrlA(const lpUrlComponents: TURLComponents;
  dwFlags: DWORD; lpszUrl: StringBuilder; var dwUrlLength: DWORD): BOOL;
function InternetCreateUrlW(const lpUrlComponents: TURLComponents;
  dwFlags: DWORD; lpszUrl: StringBuilder; var dwUrlLength: DWORD): BOOL;

function InternetCanonicalizeUrl(lpszUrl: string;
  lpszBuffer: StringBuilder; var lpdwBufferLength: DWORD;
  dwFlags: DWORD): BOOL;
function InternetCanonicalizeUrlA(lpszUrl: string;
  lpszBuffer: StringBuilder; var lpdwBufferLength: DWORD;
  dwFlags: DWORD): BOOL;
function InternetCanonicalizeUrlW(lpszUrl: string;
  lpszBuffer: StringBuilder; var lpdwBufferLength: DWORD;
  dwFlags: DWORD): BOOL;

function InternetCombineUrl(lpszBaseUrl, lpszRelativeUrl: string;
  lpszBuffer: StringBuilder; var lpdwBufferLength: DWORD;
  dwFlags: DWORD): BOOL;
function InternetCombineUrlA(lpszBaseUrl, lpszRelativeUrl: string;
  lpszBuffer: StringBuilder; var lpdwBufferLength: DWORD;
  dwFlags: DWORD): BOOL; 
function InternetCombineUrlW(lpszBaseUrl, lpszRelativeUrl: string;
  lpszBuffer: StringBuilder; var lpdwBufferLength: DWORD;
  dwFlags: DWORD): BOOL; 

const
{ flags for InternetCrackUrl and InternetCreateUrl }

  ICU_ESCAPE          = $80000000;  { (un)escape URL characters }
  ICU_USERNAME        = $40000000;  { use internal username & password }

{ flags for InternetCanonicalizeUrl and InternetCombineUrl }

  ICU_NO_ENCODE       = $20000000;  { Don't convert unsafe characters to escape sequence }
  ICU_DECODE          = $10000000;  { Convert escape sequences to characters }
  ICU_NO_META         = $08000000;  { Don't convert .. etc. meta path sequences }
  ICU_ENCODE_SPACES_ONLY     = $04000000;  { Encode spaces only }
  ICU_BROWSER_MODE    = $02000000;  { Special encode/decode rules for browser }

function InternetOpen(lpszAgent: string; dwAccessType: DWORD; lpszProxy: string;
  lpszProxyBypass: string; dwFlags: DWORD): HINTERNET; overload;
function InternetOpen(lpszAgent: string; dwAccessType: DWORD; lpszProxy: IntPtr;
  lpszProxyBypass: IntPtr; dwFlags: DWORD): HINTERNET; overload;
function InternetOpen(lpszAgent: string; dwAccessType: DWORD; lpszProxy: string;
  lpszProxyBypass: IntPtr; dwFlags: DWORD): HINTERNET; overload;
function InternetOpen(lpszAgent: string; dwAccessType: DWORD; lpszProxy: IntPtr;
  lpszProxyBypass: string; dwFlags: DWORD): HINTERNET; overload;
function InternetOpenA(lpszAgent: string; dwAccessType: DWORD;
  lpszProxy, lpszProxyBypass: string; dwFlags: DWORD): HINTERNET; 
function InternetOpenW(lpszAgent: string; dwAccessType: DWORD;
  lpszProxy, lpszProxyBypass: string; dwFlags: DWORD): HINTERNET; 

{ access types for InternetOpen }
const
  INTERNET_OPEN_TYPE_PRECONFIG        = 0;  { use registry configuration }
  INTERNET_OPEN_TYPE_DIRECT           = 1;  { direct to net }
  INTERNET_OPEN_TYPE_PROXY            = 3;  { via named proxy }
  INTERNET_OPEN_TYPE_PRECONFIG_WITH_NO_AUTOPROXY  = 4;   { prevent using java/script/INS }

{ old names for access types }

  PRE_CONFIG_INTERNET_ACCESS      = INTERNET_OPEN_TYPE_PRECONFIG;
  LOCAL_INTERNET_ACCESS           = INTERNET_OPEN_TYPE_DIRECT;
  GATEWAY_INTERNET_ACCESS         = 2;  { Internet via gateway }
  CERN_PROXY_INTERNET_ACCESS      = INTERNET_OPEN_TYPE_PROXY;

function InternetCloseHandle(hInet: HINTERNET): BOOL;

function InternetConnect(hInet: HINTERNET; lpszServerName: string;
  nServerPort: INTERNET_PORT; lpszUsername: string; lpszPassword: string;
  dwService: DWORD; dwFlags: DWORD; dwContext: DWORD): HINTERNET; overload;
function InternetConnect(hInet: HINTERNET; lpszServerName: string;
  nServerPort: INTERNET_PORT; lpszUsername: IntPtr; lpszPassword: IntPtr;
  dwService: DWORD; dwFlags: DWORD; dwContext: DWORD): HINTERNET; overload;
function InternetConnect(hInet: HINTERNET; lpszServerName: string;
  nServerPort: INTERNET_PORT; lpszUsername: string; lpszPassword: IntPtr;
  dwService: DWORD; dwFlags: DWORD; dwContext: DWORD): HINTERNET; overload;
function InternetConnect(hInet: HINTERNET; lpszServerName: string;
  nServerPort: INTERNET_PORT; lpszUsername: IntPtr; lpszPassword: string;
  dwService: DWORD; dwFlags: DWORD; dwContext: DWORD): HINTERNET; overload;
function InternetConnectA(hInet: HINTERNET; lpszServerName: string;
  nServerPort: INTERNET_PORT; lpszUsername: string; lpszPassword: string;
  dwService: DWORD; dwFlags: DWORD; dwContext: DWORD): HINTERNET; 
function InternetConnectW(hInet: HINTERNET; lpszServerName: string;
  nServerPort: INTERNET_PORT; lpszUsername: string; lpszPassword: string;
  dwService: DWORD; dwFlags: DWORD; dwContext: DWORD): HINTERNET; 

{ service types for InternetConnect }
const
  INTERNET_SERVICE_URL = 0;
  INTERNET_SERVICE_FTP = 1;
  INTERNET_SERVICE_GOPHER = 2;
  INTERNET_SERVICE_HTTP = 3;

function InternetOpenUrl(hInet: HINTERNET; lpszUrl: string;
  lpszHeaders: string; dwHeadersLength: DWORD; dwFlags: DWORD;
  dwContext: DWORD): HINTERNET;
function InternetOpenUrlA(hInet: HINTERNET; lpszUrl: string;
  lpszHeaders: string; dwHeadersLength: DWORD; dwFlags: DWORD;
  dwContext: DWORD): HINTERNET; 
function InternetOpenUrlW(hInet: HINTERNET; lpszUrl: string;
  lpszHeaders: string; dwHeadersLength: DWORD; dwFlags: DWORD;
  dwContext: DWORD): HINTERNET; 

function InternetReadFile(hFile: HINTERNET; [out] lpBuffer: TBytes;
  dwNumberOfBytesToRead: DWORD; out lpdwNumberOfBytesRead: DWORD): BOOL;

function InternetReadFileEx(hFile: HINTERNET; var lpBuffersOut: TInternetBuffers;
  dwFlags: DWORD; dwContext: DWORD): BOOL;
function InternetReadFileExA(hFile: HINTERNET; var lpBuffersOut: TInternetBuffers;
  dwFlags: DWORD; dwContext: DWORD): BOOL; 
function InternetReadFileExW(hFile: HINTERNET; var lpBuffersOut: TInternetBuffers;
  dwFlags: DWORD; dwContext: DWORD): BOOL; 

{ flags for InternetReadFileEx() }
const
  IRF_ASYNC       = WININET_API_FLAG_ASYNC;
  IRF_SYNC        = WININET_API_FLAG_SYNC;
  IRF_USE_CONTEXT = WININET_API_FLAG_USE_CONTEXT;
  IRF_NO_WAIT     = $00000008;

function InternetSetFilePointer(hFile: HINTERNET;
  lDistanceToMove: Longint; pReserved: IntPtr;
  dwMoveMethod, dwContext: DWORD): DWORD;

function InternetWriteFile(hFile: HINTERNET; [in] lpBuffer: TBytes;
  dwNumberOfBytesToWrite: DWORD;
  out lpdwNumberOfBytesWritten: DWORD): BOOL;

function InternetQueryDataAvailable(hFile: HINTERNET; out lpdwNumberOfBytesAvailable: DWORD;
  dwFlags, dwContext: DWORD): BOOL;

function InternetFindNextFile(hFind: HINTERNET;
  out lpvFindData: TWin32FindData): BOOL; overload;
function InternetFindNextFileA(hFind: HINTERNET;
  out lpvFindData: TWin32FindData): BOOL;
function InternetFindNextFileW(hFind: HINTERNET;
  out lpvFindData: TWin32FindData): BOOL;

function InternetQueryOption(hInet: HINTERNET; dwOption: DWORD;
  lpBuffer: StringBuilder; var lpdwBufferLength: DWORD): BOOL;
function InternetQueryOptionA(hInet: HINTERNET; dwOption: DWORD;
  lpBuffer: StringBuilder; var lpdwBufferLength: DWORD): BOOL;
function InternetQueryOptionW(hInet: HINTERNET; dwOption: DWORD;
  lpBuffer: StringBuilder; var lpdwBufferLength: DWORD): BOOL;

function InternetSetOption(hInet: HINTERNET; dwOption: DWORD;
  lpBuffer: string; dwBufferLength: DWORD): BOOL; overload;
function InternetSetOption(hInet: HINTERNET; dwOption: DWORD;
  lpBuffer: IntPtr; dwBufferLength: DWORD): BOOL; overload;
function InternetSetOptionA(hInet: HINTERNET; dwOption: DWORD;
  lpBuffer: string; dwBufferLength: DWORD): BOOL;
function InternetSetOptionW(hInet: HINTERNET; dwOption: DWORD;
  lpBuffer: string; dwBufferLength: DWORD): BOOL;

function InternetSetOptionEx(hInet: HINTERNET; dwOption: DWORD;
  lpBuffer: string; dwBufferLength, dwFlags: DWORD): BOOL; overload;
function InternetSetOptionEx(hInet: HINTERNET; dwOption: DWORD;
  lpBuffer: IntPtr; dwBufferLength, dwFlags: DWORD): BOOL; overload;
function InternetSetOptionExA(hInet: HINTERNET; dwOption: DWORD;
  lpBuffer: string; dwBufferLength, dwFlags: DWORD): BOOL;
function InternetSetOptionExW(hInet: HINTERNET; dwOption: DWORD;
  lpBuffer: string; dwBufferLength, dwFlags: DWORD): BOOL;

function InternetLockRequestFile(hInternet: HINTERNET;
  out lphLockRequestInfo: THandle): BOOL;

function InternetUnlockRequestFile(hLockRequestInfo: THANDLE): BOOL;

{ flags for InternetSetOptionEx() }
const
  ISO_GLOBAL      = $00000001;  { modify option globally }
  ISO_REGISTRY    = $00000002;  { write option to registry (where applicable) }
  ISO_VALID_FLAGS = ISO_GLOBAL or ISO_REGISTRY;

{ options manifests for Internet(Query or Set)Option }
const
  INTERNET_OPTION_CALLBACK = 1;
  INTERNET_OPTION_CONNECT_TIMEOUT = 2;
  INTERNET_OPTION_CONNECT_RETRIES = 3;
  INTERNET_OPTION_CONNECT_BACKOFF = 4;
  INTERNET_OPTION_SEND_TIMEOUT = 5;
  INTERNET_OPTION_CONTROL_SEND_TIMEOUT       = INTERNET_OPTION_SEND_TIMEOUT;
  INTERNET_OPTION_RECEIVE_TIMEOUT = 6;
  INTERNET_OPTION_CONTROL_RECEIVE_TIMEOUT    = INTERNET_OPTION_RECEIVE_TIMEOUT;
  INTERNET_OPTION_DATA_SEND_TIMEOUT = 7;
  INTERNET_OPTION_DATA_RECEIVE_TIMEOUT = 8;
  INTERNET_OPTION_HANDLE_TYPE = 9;
  INTERNET_OPTION_READ_BUFFER_SIZE = 12;
  INTERNET_OPTION_WRITE_BUFFER_SIZE = 13;
  INTERNET_OPTION_ASYNC_ID = 15;
  INTERNET_OPTION_ASYNC_PRIORITY = 16;
  INTERNET_OPTION_PARENT_HANDLE               = 21;
  INTERNET_OPTION_KEEP_CONNECTION             = 22;
  INTERNET_OPTION_REQUEST_FLAGS               = 23;
  INTERNET_OPTION_EXTENDED_ERROR              = 24;
  INTERNET_OPTION_OFFLINE_MODE                = 26;
  INTERNET_OPTION_CACHE_STREAM_HANDLE         = 27;
  INTERNET_OPTION_USERNAME                    = 28;
  INTERNET_OPTION_PASSWORD                    = 29;
  INTERNET_OPTION_ASYNC                       = 30;
  INTERNET_OPTION_SECURITY_FLAGS              = 31;
  INTERNET_OPTION_SECURITY_CERTIFICATE_STRUCT = 32;
  INTERNET_OPTION_DATAFILE_NAME               = 33;
  INTERNET_OPTION_URL                         = 34;
  INTERNET_OPTION_SECURITY_CERTIFICATE        = 35;
  INTERNET_OPTION_SECURITY_KEY_BITNESS        = 36;
  INTERNET_OPTION_REFRESH                     = 37;
  INTERNET_OPTION_PROXY                       = 38;
  INTERNET_OPTION_SETTINGS_CHANGED            = 39;
  INTERNET_OPTION_VERSION                     = 40;
  INTERNET_OPTION_USER_AGENT                  = 41;
  INTERNET_OPTION_END_BROWSER_SESSION         = 42;
  INTERNET_OPTION_PROXY_USERNAME              = 43;
  INTERNET_OPTION_PROXY_PASSWORD              = 44;
  INTERNET_OPTION_CONTEXT_VALUE               = 45;
  INTERNET_OPTION_CONNECT_LIMIT               = 46;
  INTERNET_OPTION_SECURITY_SELECT_CLIENT_CERT = 47;
  INTERNET_OPTION_POLICY                      = 48;
  INTERNET_OPTION_DISCONNECTED_TIMEOUT        = 49;
  INTERNET_OPTION_CONNECTED_STATE             = 50;
  INTERNET_OPTION_IDLE_STATE                  = 51;
  INTERNET_OPTION_OFFLINE_SEMANTICS           = 52;
  INTERNET_OPTION_SECONDARY_CACHE_KEY         = 53;
  INTERNET_OPTION_CALLBACK_FILTER             = 54;
  INTERNET_OPTION_CONNECT_TIME                = 55;
  INTERNET_OPTION_SEND_THROUGHPUT             = 56;
  INTERNET_OPTION_RECEIVE_THROUGHPUT          = 57;
  INTERNET_OPTION_REQUEST_PRIORITY            = 58;
  INTERNET_OPTION_HTTP_VERSION                = 59;
  INTERNET_OPTION_RESET_URLCACHE_SESSION      = 60;
  INTERNET_OPTION_ERROR_MASK                  = 62;
  INTERNET_FIRST_OPTION                      = INTERNET_OPTION_CALLBACK;
  INTERNET_LAST_OPTION                       = INTERNET_OPTION_PROXY;

{ values for INTERNET_OPTION_PRIORITY }

  INTERNET_PRIORITY_FOREGROUND = 1000;

{ handle types }

  INTERNET_HANDLE_TYPE_INTERNET = 1;
  INTERNET_HANDLE_TYPE_CONNECT_FTP = 2;
  INTERNET_HANDLE_TYPE_CONNECT_GOPHER = 3;
  INTERNET_HANDLE_TYPE_CONNECT_HTTP = 4;
  INTERNET_HANDLE_TYPE_FTP_FIND = 5;
  INTERNET_HANDLE_TYPE_FTP_FIND_HTML = 6;
  INTERNET_HANDLE_TYPE_FTP_FILE = 7;
  INTERNET_HANDLE_TYPE_FTP_FILE_HTML = 8;
  INTERNET_HANDLE_TYPE_GOPHER_FIND = 9;
  INTERNET_HANDLE_TYPE_GOPHER_FIND_HTML = 10;
  INTERNET_HANDLE_TYPE_GOPHER_FILE = 11;
  INTERNET_HANDLE_TYPE_GOPHER_FILE_HTML = 12;
  INTERNET_HANDLE_TYPE_HTTP_REQUEST = 13;

{ values for INTERNET_OPTION_SECURITY_FLAGS }

  SECURITY_FLAG_SECURE                        = $00000001; { can query only }
  SECURITY_FLAG_SSL                           = $00000002;
  SECURITY_FLAG_SSL3                          = $00000004;
  SECURITY_FLAG_PCT                           = $00000008;
  SECURITY_FLAG_PCT4                          = $00000010;
  SECURITY_FLAG_IETFSSL4                      = $00000020;
  SECURITY_FLAG_STRENGTH_WEAK                 = $10000000;
  SECURITY_FLAG_STRENGTH_MEDIUM               = $40000000;
  SECURITY_FLAG_STRENGTH_STRONG               = $20000000;
  SECURITY_FLAG_40BIT                         = SECURITY_FLAG_STRENGTH_WEAK;
  SECURITY_FLAG_128BIT                        = SECURITY_FLAG_STRENGTH_STRONG;
  SECURITY_FLAG_56BIT                         = SECURITY_FLAG_STRENGTH_MEDIUM;
  SECURITY_FLAG_UNKNOWNBIT                    = $80000000;
  SECURITY_FLAG_NORMALBITNESS                 = SECURITY_FLAG_40BIT;
  SECURITY_FLAG_IGNORE_REVOCATION             = $00000080;
  SECURITY_FLAG_IGNORE_UNKNOWN_CA             = $00000100;
  SECURITY_FLAG_IGNORE_WRONG_USAGE            = $00000200;
  SECURITY_FLAG_IGNORE_CERT_CN_INVALID        = INTERNET_FLAG_IGNORE_CERT_CN_INVALID;
  SECURITY_FLAG_IGNORE_CERT_DATE_INVALID      = INTERNET_FLAG_IGNORE_CERT_DATE_INVALID;
  SECURITY_FLAG_IGNORE_REDIRECT_TO_HTTPS      = INTERNET_FLAG_IGNORE_REDIRECT_TO_HTTPS;
  SECURITY_FLAG_IGNORE_REDIRECT_TO_HTTP       = INTERNET_FLAG_IGNORE_REDIRECT_TO_HTTP;

function InternetGetLastResponseInfo(out lpdwError: DWORD; lpszBuffer: StringBuilder;
  var lpdwBufferLength: DWORD): BOOL;
function InternetGetLastResponseInfoA(out lpdwError: DWORD; lpszBuffer: StringBuilder;
  var lpdwBufferLength: DWORD): BOOL;
function InternetGetLastResponseInfoW(out lpdwError: DWORD; lpszBuffer: StringBuilder;
  var lpdwBufferLength: DWORD): BOOL; 

{ callback function for InternetSetStatusCallback }
type
  INTERNET_STATUS_CALLBACK = procedure (hInet: HINTERNET;
    [in] var dwContext: DWORD; dwInternetStatus: DWORD; lpvStatusInformation: IntPtr;
    dwStatusInformationLength: DWORD);
  TFNInternetStatusCallback = INTERNET_STATUS_CALLBACK;

{ InternetSetStatusCallback is declared as returning a
  ^TFNInternetStatusCallback in Win32. }
function InternetSetStatusCallback(hInet: HINTERNET;
  const lpfnInternetCallback: TFNInternetStatusCallback): IntPtr;

{ status manifests for Internet status callback }
const
  INTERNET_STATUS_RESOLVING_NAME              = 10;
  INTERNET_STATUS_NAME_RESOLVED               = 11;
  INTERNET_STATUS_CONNECTING_TO_SERVER        = 20;
  INTERNET_STATUS_CONNECTED_TO_SERVER         = 21;
  INTERNET_STATUS_SENDING_REQUEST             = 30;
  INTERNET_STATUS_REQUEST_SENT                = 31;
  INTERNET_STATUS_RECEIVING_RESPONSE          = 40;
  INTERNET_STATUS_RESPONSE_RECEIVED           = 41;
  INTERNET_STATUS_CTL_RESPONSE_RECEIVED       = 42;
  INTERNET_STATUS_PREFETCH                    = 43;
  INTERNET_STATUS_CLOSING_CONNECTION          = 50;
  INTERNET_STATUS_CONNECTION_CLOSED           = 51;
  INTERNET_STATUS_HANDLE_CREATED              = 60;
  INTERNET_STATUS_HANDLE_CLOSING              = 70;
  INTERNET_STATUS_REQUEST_COMPLETE            = 100;
  INTERNET_STATUS_REDIRECT                    = 110;
  INTERNET_STATUS_INTERMEDIATE_RESPONSE       = 120;
  INTERNET_STATUS_STATE_CHANGE                = 200;

{ the following can be indicated in a state change notification: }
  INTERNET_STATE_CONNECTED                    = $00000001;  { connected state (mutually exclusive with disconnected) }
  INTERNET_STATE_DISCONNECTED                 = $00000002;  { disconnected from network }
  INTERNET_STATE_DISCONNECTED_BY_USER         = $00000010;  { disconnected by user request }
  INTERNET_STATE_IDLE                         = $00000100;  { no network requests being made (by Wininet) }
  INTERNET_STATE_BUSY                         = $00000200;  { network requests being made (by Wininet) }

{ if the following value is returned by InternetSetStatusCallback, then }
{ probably an invalid (non-code) address was supplied for the callback }

  INTERNET_INVALID_STATUS_CALLBACK = (-1);

{ prototypes }

function FtpFindFirstFile(hConnect: HINTERNET; lpszSearchFile: string;
  out lpFindFileData: TWin32FindData; dwFlags: DWORD;
  dwContext: DWORD): HINTERNET;
function FtpFindFirstFileA(hConnect: HINTERNET; lpszSearchFile: string;
  out lpFindFileData: TWin32FindDataA; dwFlags: DWORD;
  dwContext: DWORD): HINTERNET;
function FtpFindFirstFileW(hConnect: HINTERNET; lpszSearchFile: string;
  out lpFindFileData: TWin32FindDataW; dwFlags: DWORD;
  dwContext: DWORD): HINTERNET;

function FtpGetFile(hConnect: HINTERNET; lpszRemoteFile: string;
  lpszNewFile: string; fFailIfExists: BOOL; dwFlagsAndAttributes: DWORD;
  dwFlags: DWORD; dwContext: DWORD): BOOL;
function FtpGetFileA(hConnect: HINTERNET; lpszRemoteFile: string;
  lpszNewFile: string; fFailIfExists: BOOL; dwFlagsAndAttributes: DWORD;
  dwFlags: DWORD; dwContext: DWORD): BOOL;
function FtpGetFileW(hConnect: HINTERNET; lpszRemoteFile: string;
  lpszNewFile: string; fFailIfExists: BOOL; dwFlagsAndAttributes: DWORD;
  dwFlags: DWORD; dwContext: DWORD): BOOL; 

function FtpPutFile(hConnect: HINTERNET; lpszLocalFile: string;
  lpszNewRemoteFile: string; dwFlags: DWORD; dwContext: DWORD): BOOL;
function FtpPutFileA(hConnect: HINTERNET; lpszLocalFile: string;
  lpszNewRemoteFile: string; dwFlags: DWORD; dwContext: DWORD): BOOL; 
function FtpPutFileW(hConnect: HINTERNET; lpszLocalFile: string;
  lpszNewRemoteFile: string; dwFlags: DWORD; dwContext: DWORD): BOOL; 

function FtpDeleteFile(hConnect: HINTERNET; lpszFileName: string): BOOL;
function FtpDeleteFileA(hConnect: HINTERNET; lpszFileName: string): BOOL; 
function FtpDeleteFileW(hConnect: HINTERNET; lpszFileName: string): BOOL; 

function FtpRenameFile(hConnect: HINTERNET; lpszExisting: string;
  lpszNew: string): BOOL;
function FtpRenameFileA(hConnect: HINTERNET; lpszExisting: string;
  lpszNew: string): BOOL; 
function FtpRenameFileW(hConnect: HINTERNET; lpszExisting: string;
  lpszNew: string): BOOL; 

function FtpOpenFile(hConnect: HINTERNET; lpszFileName: string;
  dwAccess: DWORD; dwFlags: DWORD; dwContext: DWORD): HINTERNET;
function FtpOpenFileA(hConnect: HINTERNET; lpszFileName: string;
  dwAccess: DWORD; dwFlags: DWORD; dwContext: DWORD): HINTERNET; 
function FtpOpenFileW(hConnect: HINTERNET; lpszFileName: string;
  dwAccess: DWORD; dwFlags: DWORD; dwContext: DWORD): HINTERNET;

function FtpCreateDirectory(hConnect: HINTERNET; lpszDirectory: string): BOOL;
function FtpCreateDirectoryA(hConnect: HINTERNET; lpszDirectory: string): BOOL; 
function FtpCreateDirectoryW(hConnect: HINTERNET; lpszDirectory: string): BOOL; 

function FtpRemoveDirectory(hConnect: HINTERNET; lpszDirectory: string): BOOL;
function FtpRemoveDirectoryA(hConnect: HINTERNET; lpszDirectory: string): BOOL; 
function FtpRemoveDirectoryW(hConnect: HINTERNET; lpszDirectory: string): BOOL; 

function FtpSetCurrentDirectory(hConnect: HINTERNET; lpszDirectory: string): BOOL;
function FtpSetCurrentDirectoryA(hConnect: HINTERNET; lpszDirectory: string): BOOL; 
function FtpSetCurrentDirectoryW(hConnect: HINTERNET; lpszDirectory: string): BOOL; 

function FtpGetCurrentDirectory(hConnect: HINTERNET;
  lpszCurrentDirectory: StringBuilder; var lpdwCurrentDirectory: DWORD): BOOL;
function FtpGetCurrentDirectoryA(hConnect: HINTERNET;
  lpszCurrentDirectory: StringBuilder; var lpdwCurrentDirectory: DWORD): BOOL; 
function FtpGetCurrentDirectoryW(hConnect: HINTERNET;
  lpszCurrentDirectory: StringBuilder; var lpdwCurrentDirectory: DWORD): BOOL;

function FtpCommand(hConnect: HINTERNET; fExpectResponse: BOOL;
  dwFlags: DWORD; lpszCommand: string; dwContext: DWORD): BOOL;
function FtpCommandA(hConnect: HINTERNET; fExpectResponse: BOOL;
  dwFlags: DWORD; lpszCommand: string; dwContext: DWORD): BOOL; 
function FtpCommandW(hConnect: HINTERNET; fExpectResponse: BOOL;
  dwFlags: DWORD; lpszCommand: string; dwContext: DWORD): BOOL;

function FtpGetFileSize(hFile: HINTERNET; out lpdwFileSizeHigh: DWORD): DWORD; 

{ Gopher }

{ manifests }

{ string field lengths (in characters, not bytes) }
const
  MAX_GOPHER_DISPLAY_TEXT   = 128;
  MAX_GOPHER_SELECTOR_TEXT  = 256;
  MAX_GOPHER_HOST_NAME      = INTERNET_MAX_HOST_NAME_LENGTH;
  MAX_GOPHER_LOCATOR_LENGTH = 1
                              + MAX_GOPHER_DISPLAY_TEXT
                              + 1
                              + MAX_GOPHER_SELECTOR_TEXT
                              + 1
                              + MAX_GOPHER_HOST_NAME
                              + 1
                              + INTERNET_MAX_PORT_NUMBER_LENGTH
                              + 1
                              + 1
                              + 2;

{ structures/types }

{ GOPHER_FIND_DATA - returns the results of a GopherFindFirstFile/ }
{ InternetFindNextFile request }

type
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Auto)]
  GOPHER_FIND_DATA = record
    [MarshalAs(UnmanagedType.ByValTStr, SizeConst=MAX_GOPHER_DISPLAY_TEXT)]
    DisplayString: string;
    GopherType: DWORD;  { GopherType - if known }
    SizeLow: DWORD;
    SizeHigh: DWORD;
    LastModificationTime: TFileTime;
    [MarshalAs(UnmanagedType.ByValTStr, SizeConst=MAX_GOPHER_LOCATOR_LENGTH)]
    Locator: string;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Ansi)]
  GOPHER_FIND_DATAA = record
    [MarshalAs(UnmanagedType.ByValTStr, SizeConst=MAX_GOPHER_DISPLAY_TEXT)]
    DisplayString: string;
    GopherType: DWORD;  { GopherType - if known }
    SizeLow: DWORD;
    SizeHigh: DWORD;
    LastModificationTime: TFileTime;
    [MarshalAs(UnmanagedType.ByValTStr, SizeConst=MAX_GOPHER_LOCATOR_LENGTH)]
    Locator: string;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Unicode)]
  GOPHER_FIND_DATAW = record
    [MarshalAs(UnmanagedType.ByValTStr, SizeConst=MAX_GOPHER_DISPLAY_TEXT)]
    DisplayString: string;
    GopherType: DWORD;  { GopherType - if known }
    SizeLow: DWORD;
    SizeHigh: DWORD;
    LastModificationTime: TFileTime;
    [MarshalAs(UnmanagedType.ByValTStr, SizeConst=MAX_GOPHER_LOCATOR_LENGTH)]
    Locator: string;
  end;
  TGopherFindData = GOPHER_FIND_DATA;
  TGopherFindDataA = GOPHER_FIND_DATAA;
  TGopherFindDataW = GOPHER_FIND_DATAW;

{ manifests for GopherType }
const
  GOPHER_TYPE_TEXT_FILE = $00000001;
  GOPHER_TYPE_DIRECTORY = $00000002;
  GOPHER_TYPE_CSO = $00000004;
  GOPHER_TYPE_ERROR = $00000008;
  GOPHER_TYPE_MAC_BINHEX = $00000010;
  GOPHER_TYPE_DOS_ARCHIVE = $00000020;
  GOPHER_TYPE_UNIX_UUENCODED = $00000040;
  GOPHER_TYPE_INDEX_SERVER = $00000080;
  GOPHER_TYPE_TELNET = $00000100;
  GOPHER_TYPE_BINARY = $00000200;
  GOPHER_TYPE_REDUNDANT = $00000400;
  GOPHER_TYPE_TN3270 = $00000800;
  GOPHER_TYPE_GIF = $00001000;
  GOPHER_TYPE_IMAGE = $00002000;
  GOPHER_TYPE_BITMAP = $00004000;
  GOPHER_TYPE_MOVIE = $00008000;
  GOPHER_TYPE_SOUND = $00010000;
  GOPHER_TYPE_HTML = $00020000;
  GOPHER_TYPE_PDF = $00040000;
  GOPHER_TYPE_CALENDAR = $00080000;
  GOPHER_TYPE_INLINE = $00100000;
  GOPHER_TYPE_UNKNOWN = $20000000;
  GOPHER_TYPE_ASK = $40000000;
  GOPHER_TYPE_GOPHER_PLUS = $80000000;

{ Gopher Type functions }

function IS_GOPHER_FILE(GopherType: DWORD): BOOL;
function IS_GOPHER_DIRECTORY(GopherType: DWORD): BOOL;
function IS_GOPHER_PHONE_SERVER(GopherType: DWORD): BOOL;
function IS_GOPHER_ERROR(GopherType: DWORD): BOOL;
function IS_GOPHER_INDEX_SERVER(GopherType: DWORD): BOOL;
function IS_GOPHER_TELNET_SESSION(GopherType: DWORD): BOOL;
function IS_GOPHER_BACKUP_SERVER(GopherType: DWORD): BOOL;
function IS_GOPHER_TN3270_SESSION(GopherType: DWORD): BOOL;
function IS_GOPHER_ASK(GopherType: DWORD): BOOL;
function IS_GOPHER_PLUS(GopherType: DWORD): BOOL;
function IS_GOPHER_TYPE_KNOWN(GopherType: DWORD): BOOL;

{ GOPHER_TYPE_FILE_MASK - use this to determine if a locator identifies a }
{ (known) file type }
const
  GOPHER_TYPE_FILE_MASK = GOPHER_TYPE_TEXT_FILE
                          or GOPHER_TYPE_MAC_BINHEX
                          or GOPHER_TYPE_DOS_ARCHIVE
                          or GOPHER_TYPE_UNIX_UUENCODED
                          or GOPHER_TYPE_BINARY
                          or GOPHER_TYPE_GIF
                          or GOPHER_TYPE_IMAGE
                          or GOPHER_TYPE_BITMAP
                          or GOPHER_TYPE_MOVIE
                          or GOPHER_TYPE_SOUND
                          or GOPHER_TYPE_HTML
                          or GOPHER_TYPE_PDF
                          or GOPHER_TYPE_CALENDAR
                          or GOPHER_TYPE_INLINE;

{ structured gopher attributes (as defined in gopher+ protocol document) }
type
  [StructLayout(LayoutKind.Sequential)]
  GOPHER_ADMIN_ATTRIBUTE_TYPE = record
    Comment: IntPtr; { string }
    EmailAddress: IntPtr; { string }
  end;
  TGopherAdminAttributeType = GOPHER_ADMIN_ATTRIBUTE_TYPE;

  [StructLayout(LayoutKind.Sequential)]
  GOPHER_MOD_DATE_ATTRIBUTE_TYPE = record
    DateAndTime: TFileTime;
  end;
  TGopherModDateAttributeType = GOPHER_MOD_DATE_ATTRIBUTE_TYPE;

  [StructLayout(LayoutKind.Sequential)]
  GOPHER_TTL_ATTRIBUTE_TYPE = record
    Ttl: DWORD;
  end;
  TGopherTtlAttributeType = GOPHER_TTL_ATTRIBUTE_TYPE;

  [StructLayout(LayoutKind.Sequential)]
  GOPHER_SCORE_ATTRIBUTE_TYPE = record
    Score: Integer;
  end;
  TGopherScoreAttributeType = GOPHER_SCORE_ATTRIBUTE_TYPE;

  [StructLayout(LayoutKind.Sequential)]
  GOPHER_SCORE_RANGE_ATTRIBUTE_TYPE = record
    LowerBound: Integer;
    UpperBound: Integer;
  end;
  TGopherScoreRangeAttributeType = GOPHER_SCORE_RANGE_ATTRIBUTE_TYPE;

  [StructLayout(LayoutKind.Sequential)]
  GOPHER_SITE_ATTRIBUTE_TYPE = record
    Site: IntPtr; { string }
  end;
  TGopherSiteAttributeType = GOPHER_SITE_ATTRIBUTE_TYPE;

  [StructLayout(LayoutKind.Sequential)]
  GOPHER_ORGANIZATION_ATTRIBUTE_TYPE = record
    Organization: IntPtr; { string }
  end;
  TGopherOrganizationAttributeType = GOPHER_ORGANIZATION_ATTRIBUTE_TYPE;

  [StructLayout(LayoutKind.Sequential)]
  GOPHER_LOCATION_ATTRIBUTE_TYPE = record
    Location: IntPtr; { string }
  end;
  TGopherLocationAttributeType = GOPHER_LOCATION_ATTRIBUTE_TYPE;

  [StructLayout(LayoutKind.Sequential)]
  GOPHER_GEOGRAPHICAL_LOCATION_ATTRIBUTE_TYPE = record
    DegreesNorth: Integer;
    MinutesNorth: Integer;
    SecondsNorth: Integer;
    DegreesEast: Integer;
    MinutesEast: Integer;
    SecondsEast: Integer;
  end;
  TGopherGeographicalLocationAttributeType = GOPHER_GEOGRAPHICAL_LOCATION_ATTRIBUTE_TYPE;

  [StructLayout(LayoutKind.Sequential)]
  GOPHER_TIMEZONE_ATTRIBUTE_TYPE = record
    Zone: Integer;
  end;
  TGopherTimezoneAttributeType = GOPHER_TIMEZONE_ATTRIBUTE_TYPE;

  [StructLayout(LayoutKind.Sequential)]
  GOPHER_PROVIDER_ATTRIBUTE_TYPE = record
    Provider: IntPtr; { string }
  end;
  TGopherProviderAttributeType = GOPHER_PROVIDER_ATTRIBUTE_TYPE;

  [StructLayout(LayoutKind.Sequential)]
  GOPHER_VERSION_ATTRIBUTE_TYPE = record
    Version: IntPtr; { string }
  end;
  TGopherVersionAttributeType = GOPHER_VERSION_ATTRIBUTE_TYPE;

  [StructLayout(LayoutKind.Sequential)]
  GOPHER_ABSTRACT_ATTRIBUTE_TYPE = record
    ShortAbstract: IntPtr; { string }
    AbstractFile: IntPtr; { string }
  end;
  TGopherAbstractAttributeType = GOPHER_ABSTRACT_ATTRIBUTE_TYPE;

  [StructLayout(LayoutKind.Sequential)]
  GOPHER_VIEW_ATTRIBUTE_TYPE = record
    ContentType: IntPtr; { string }
    Language: IntPtr; { string }
    Size: DWORD;
  end;
  TGopherViewAttributeType = GOPHER_VIEW_ATTRIBUTE_TYPE;

  [StructLayout(LayoutKind.Sequential)]
  GOPHER_VERONICA_ATTRIBUTE_TYPE = record
    TreeWalk: BOOL;
  end;
  TGopherVeronicaAttributeType = GOPHER_VERONICA_ATTRIBUTE_TYPE;

  [StructLayout(LayoutKind.Sequential)]
  GOPHER_ASK_ATTRIBUTE_TYPE = record
    QuestionType: IntPtr; { string }
    QuestionText: IntPtr; { string }
  end;
  TGopherAskAttributeType = GOPHER_ASK_ATTRIBUTE_TYPE;

{ GOPHER_UNKNOWN_ATTRIBUTE_TYPE - this is returned if we retrieve an attribute }
{ that is not specified in the current gopher/gopher+ documentation. It is up }
{ to the application to parse the information }

  [StructLayout(LayoutKind.Sequential)]
  GOPHER_UNKNOWN_ATTRIBUTE_TYPE = record
    Text: IntPtr; { string }
  end;
  TGopherUnknownAttributeType = GOPHER_UNKNOWN_ATTRIBUTE_TYPE;

{ GOPHER_ATTRIBUTE_TYPE - returned in the user's buffer when an enumerated }
{ GopherGetAttribute call is made }

  GOPHER_ATTRIBUTE_TYPE = record
    CategoryId: DWORD;  { e.g. GOPHER_CATEGORY_ID_ADMIN }
    AttributeId: DWORD; { e.g. GOPHER_ATTRIBUTE_ID_ADMIN }
    case Integer of
      0: (Admin: TGopherAdminAttributeType);
      1: (ModDate: TGopherModDateAttributeType);
      2: (Ttl: TGopherTtlAttributeType);
      3: (Score: TGopherScoreAttributeType);
      4: (ScoreRange: TGopherScoreRangeAttributeType);
      5: (Site: TGopherSiteAttributeType);
      6: (Organization: TGopherOrganizationAttributeType);
      7: (Location: TGopherLocationAttributeType);
      8: (GeographicalLocation: TGopherGeographicalLocationAttributeType);
      9: (TimeZone: TGopherTimezoneAttributeType);
      10: (Provider: TGopherProviderAttributeType);
      11: (Version: TGopherVersionAttributeType);
      12: (AbstractType: TGopherAbstractAttributeType);
      13: (View: TGopherViewAttributeType);
      14: (Veronica: TGopherVeronicaAttributeType);
      15: (Ask: TGopherAskAttributeType);
      16: (Unknown: TGopherUnknownAttributeType);
    end;
  TGopherAttributeType = GOPHER_ATTRIBUTE_TYPE;

const
  MAX_GOPHER_CATEGORY_NAME = 128;           { arbitrary }
  MAX_GOPHER_ATTRIBUTE_NAME = 128;          {     " }
  MIN_GOPHER_ATTRIBUTE_LENGTH = 256;        {     " }

{ known gopher attribute categories. See below for ordinals }

  GOPHER_INFO_CATEGORY           = '+INFO';
  GOPHER_ADMIN_CATEGORY          = '+ADMIN';
  GOPHER_VIEWS_CATEGORY          = '+VIEWS';
  GOPHER_ABSTRACT_CATEGORY       = '+ABSTRACT';
  GOPHER_VERONICA_CATEGORY       = '+VERONICA';

{ known gopher attributes. These are the attribute names as defined in the }
{ gopher+ protocol document }

  GOPHER_ADMIN_ATTRIBUTE         = 'Admin';
  GOPHER_MOD_DATE_ATTRIBUTE      = 'Mod-Date';
  GOPHER_TTL_ATTRIBUTE           = 'TTL';
  GOPHER_SCORE_ATTRIBUTE         = 'Score';
  GOPHER_RANGE_ATTRIBUTE         = 'Score-range';
  GOPHER_SITE_ATTRIBUTE          = 'Site';
  GOPHER_ORG_ATTRIBUTE           = 'Org';
  GOPHER_LOCATION_ATTRIBUTE      = 'Loc';
  GOPHER_GEOG_ATTRIBUTE          = 'Geog';
  GOPHER_TIMEZONE_ATTRIBUTE      = 'TZ';
  GOPHER_PROVIDER_ATTRIBUTE      = 'Provider';
  GOPHER_VERSION_ATTRIBUTE       = 'Version';
  GOPHER_ABSTRACT_ATTRIBUTE      = 'Abstract';
  GOPHER_VIEW_ATTRIBUTE          = 'View';
  GOPHER_TREEWALK_ATTRIBUTE      = 'treewalk';

{ identifiers for attribute strings }

  GOPHER_ATTRIBUTE_ID_BASE = $abcccc00;
  GOPHER_CATEGORY_ID_ALL = GOPHER_ATTRIBUTE_ID_BASE + 1;
  GOPHER_CATEGORY_ID_INFO = GOPHER_ATTRIBUTE_ID_BASE + 2;
  GOPHER_CATEGORY_ID_ADMIN = GOPHER_ATTRIBUTE_ID_BASE + 3;
  GOPHER_CATEGORY_ID_VIEWS = GOPHER_ATTRIBUTE_ID_BASE + 4;
  GOPHER_CATEGORY_ID_ABSTRACT = GOPHER_ATTRIBUTE_ID_BASE + 5;
  GOPHER_CATEGORY_ID_VERONICA = GOPHER_ATTRIBUTE_ID_BASE + 6;
  GOPHER_CATEGORY_ID_ASK = GOPHER_ATTRIBUTE_ID_BASE + 7;
  GOPHER_CATEGORY_ID_UNKNOWN = GOPHER_ATTRIBUTE_ID_BASE + 8;
  GOPHER_ATTRIBUTE_ID_ALL = GOPHER_ATTRIBUTE_ID_BASE + 9;
  GOPHER_ATTRIBUTE_ID_ADMIN = GOPHER_ATTRIBUTE_ID_BASE + 10;
  GOPHER_ATTRIBUTE_ID_MOD_DATE = GOPHER_ATTRIBUTE_ID_BASE + 11;
  GOPHER_ATTRIBUTE_ID_TTL = GOPHER_ATTRIBUTE_ID_BASE + 12;
  GOPHER_ATTRIBUTE_ID_SCORE = GOPHER_ATTRIBUTE_ID_BASE + 13;
  GOPHER_ATTRIBUTE_ID_RANGE = GOPHER_ATTRIBUTE_ID_BASE + 14;
  GOPHER_ATTRIBUTE_ID_SITE = GOPHER_ATTRIBUTE_ID_BASE + 15;
  GOPHER_ATTRIBUTE_ID_ORG = GOPHER_ATTRIBUTE_ID_BASE + 16;
  GOPHER_ATTRIBUTE_ID_LOCATION = GOPHER_ATTRIBUTE_ID_BASE + 17;
  GOPHER_ATTRIBUTE_ID_GEOG = GOPHER_ATTRIBUTE_ID_BASE + 18;
  GOPHER_ATTRIBUTE_ID_TIMEZONE = GOPHER_ATTRIBUTE_ID_BASE + 19;
  GOPHER_ATTRIBUTE_ID_PROVIDER = GOPHER_ATTRIBUTE_ID_BASE + 20;
  GOPHER_ATTRIBUTE_ID_VERSION = GOPHER_ATTRIBUTE_ID_BASE + 21;
  GOPHER_ATTRIBUTE_ID_ABSTRACT = GOPHER_ATTRIBUTE_ID_BASE + 22;
  GOPHER_ATTRIBUTE_ID_VIEW = GOPHER_ATTRIBUTE_ID_BASE + 23;
  GOPHER_ATTRIBUTE_ID_TREEWALK = GOPHER_ATTRIBUTE_ID_BASE + 24;
  GOPHER_ATTRIBUTE_ID_UNKNOWN = GOPHER_ATTRIBUTE_ID_BASE + 25;
  
{ prototypes }

function InternetFindNextFile(hFind: HINTERNET;
  out lpvFindData: TGopherFindData): BOOL; overload;

function GopherCreateLocator(lpszHost: string; nServerPort: INTERNET_PORT;
  lpszDisplayString: string; lpszSelectorString: string; dwGopherType: DWORD;
  lpszLocator: StringBuilder; var lpdwBufferLength: DWORD): BOOL; overload;
function GopherCreateLocator(lpszHost: string; nServerPort: INTERNET_PORT;
  lpszDisplayString: IntPtr; lpszSelectorString: IntPtr; dwGopherType: DWORD;
  lpszLocator: StringBuilder; var lpdwBufferLength: DWORD): BOOL; overload;
function GopherCreateLocator(lpszHost: string; nServerPort: INTERNET_PORT;
  lpszDisplayString: string; lpszSelectorString: IntPtr; dwGopherType: DWORD;
  lpszLocator: StringBuilder; var lpdwBufferLength: DWORD): BOOL; overload;
function GopherCreateLocator(lpszHost: string; nServerPort: INTERNET_PORT;
  lpszDisplayString: IntPtr; lpszSelectorString: string; dwGopherType: DWORD;
  lpszLocator: StringBuilder; var lpdwBufferLength: DWORD): BOOL; overload;
function GopherCreateLocatorA(lpszHost: string; nServerPort: INTERNET_PORT;
  lpszDisplayString: string; lpszSelectorString: string; dwGopherType: DWORD;
  lpszLocator: StringBuilder; var lpdwBufferLength: DWORD): BOOL;
function GopherCreateLocatorW(lpszHost: string; nServerPort: INTERNET_PORT;
  lpszDisplayString: string; lpszSelectorString: string; dwGopherType: DWORD;
  lpszLocator: StringBuilder; var lpdwBufferLength: DWORD): BOOL;

function GopherGetLocatorType(lpszLocator: string;
  out lpdwGopherType: DWORD): BOOL;
function GopherGetLocatorTypeA(lpszLocator: string;
  out lpdwGopherType: DWORD): BOOL;
function GopherGetLocatorTypeW(lpszLocator: string;
  out lpdwGopherType: DWORD): BOOL; 

function GopherFindFirstFile(hConnect: HINTERNET; lpszLocator: string;
  lpszSearchString: string; out lpFindData: TGopherFindData; dwFlags: DWORD;
  dwContext: DWORD): HINTERNET;
function GopherFindFirstFileA(hConnect: HINTERNET; lpszLocator: string;
  lpszSearchString: string; out lpFindData: TGopherFindDataA; dwFlags: DWORD;
  dwContext: DWORD): HINTERNET; 
function GopherFindFirstFileW(hConnect: HINTERNET; lpszLocator: string;
  lpszSearchString: string; out lpFindData: TGopherFindDataW; dwFlags: DWORD;
  dwContext: DWORD): HINTERNET; 

function GopherOpenFile(hConnect: HINTERNET; lpszLocator: string;
  lpszView: string; dwFlags: DWORD; dwContext: DWORD): HINTERNET;
function GopherOpenFileA(hConnect: HINTERNET; lpszLocator: string;
  lpszView: string; dwFlags: DWORD; dwContext: DWORD): HINTERNET; 
function GopherOpenFileW(hConnect: HINTERNET; lpszLocator: string;
  lpszView: string; dwFlags: DWORD; dwContext: DWORD): HINTERNET; 

type
  GOPHER_ATTRIBUTE_ENUMERATOR =
    function (const lpAttributeInfo: TGopherAttributeType; dwError: DWORD): BOOL;
  TFNGopherAttributeEnumerator = GOPHER_ATTRIBUTE_ENUMERATOR;

function GopherGetAttribute(hConnect: HINTERNET; lpszLocator: string;
  lpszAttributeName: string; lpBuffer: StringBuilder; dwBufferLength: DWORD;
  out lpdwCharactersReturned: DWORD; const lpfnEnumerator: TFNGopherAttributeEnumerator;
  dwContext: DWORD): BOOL;
function GopherGetAttributeA(hConnect: HINTERNET; lpszLocator: string;
  lpszAttributeName: string; lpBuffer: StringBuilder; dwBufferLength: DWORD;
  out lpdwCharactersReturned: DWORD; const lpfnEnumerator: TFNGopherAttributeEnumerator;
  dwContext: DWORD): BOOL;
function GopherGetAttributeW(hConnect: HINTERNET; lpszLocator: string;
  lpszAttributeName: string; lpBuffer: StringBuilder; dwBufferLength: DWORD;
  out lpdwCharactersReturned: DWORD; const lpfnEnumerator: TFNGopherAttributeEnumerator;
  dwContext: DWORD): BOOL; 

{ HTTP }

{ manifests }

const
{ the default major/minor HTTP version numbers }

  HTTP_MAJOR_VERSION = 1;
  HTTP_MINOR_VERSION = 0;
  HTTP_VERSION       = 'HTTP/1.0';

{ HttpQueryInfo info levels. Generally, there is one info level }
{ for each potential RFC822/HTTP/MIME header that an HTTP server }
{ may send as part of a request response. }

{ The HTTP_QUERY_RAW_HEADERS info level is provided for clients }
{ that choose to perform their own header parsing. }

  HTTP_QUERY_MIME_VERSION                     = 0;
  HTTP_QUERY_CONTENT_TYPE                     = 1;
  HTTP_QUERY_CONTENT_TRANSFER_ENCODING        = 2;
  HTTP_QUERY_CONTENT_ID                       = 3;
  HTTP_QUERY_CONTENT_DESCRIPTION              = 4;
  HTTP_QUERY_CONTENT_LENGTH                   = 5;
  HTTP_QUERY_CONTENT_LANGUAGE                 = 6;
  HTTP_QUERY_ALLOW                            = 7;
  HTTP_QUERY_PUBLIC                           = 8;
  HTTP_QUERY_DATE                             = 9;
  HTTP_QUERY_EXPIRES                          = 10;
  HTTP_QUERY_LAST_MODIFIED                    = 11;
  HTTP_QUERY_MESSAGE_ID                       = 12;
  HTTP_QUERY_URI                              = 13;
  HTTP_QUERY_DERIVED_FROM                     = 14;
  HTTP_QUERY_COST                             = 15;
  HTTP_QUERY_LINK                             = 16;
  HTTP_QUERY_PRAGMA                           = 17;
  HTTP_QUERY_VERSION                          = 18; { special: part of status line }
  HTTP_QUERY_STATUS_CODE                      = 19; { special: part of status line }
  HTTP_QUERY_STATUS_TEXT                      = 20; { special: part of status line }
  HTTP_QUERY_RAW_HEADERS                      = 21; { special: all headers as ASCIIZ }
  HTTP_QUERY_RAW_HEADERS_CRLF                 = 22; { special: all headers }
  HTTP_QUERY_CONNECTION                       = 23;
  HTTP_QUERY_ACCEPT                           = 24;
  HTTP_QUERY_ACCEPT_CHARSET                   = 25;
  HTTP_QUERY_ACCEPT_ENCODING                  = 26;
  HTTP_QUERY_ACCEPT_LANGUAGE                  = 27;
  HTTP_QUERY_AUTHORIZATION                    = 28;
  HTTP_QUERY_CONTENT_ENCODING                 = 29;
  HTTP_QUERY_FORWARDED                        = 30;
  HTTP_QUERY_FROM                             = 31;
  HTTP_QUERY_IF_MODIFIED_SINCE                = 32;
  HTTP_QUERY_LOCATION                         = 33;
  HTTP_QUERY_ORIG_URI                         = 34;
  HTTP_QUERY_REFERER                          = 35;
  HTTP_QUERY_RETRY_AFTER                      = 36;
  HTTP_QUERY_SERVER                           = 37;
  HTTP_QUERY_TITLE                            = 38;
  HTTP_QUERY_USER_AGENT                       = 39;
  HTTP_QUERY_WWW_AUTHENTICATE                 = 40;
  HTTP_QUERY_PROXY_AUTHENTICATE               = 41;
  HTTP_QUERY_ACCEPT_RANGES                    = 42;
  HTTP_QUERY_SET_COOKIE                       = 43;
  HTTP_QUERY_COOKIE                           = 44;
  HTTP_QUERY_REQUEST_METHOD                   = 45;  { special: GET/POST etc. }
  HTTP_QUERY_REFRESH                          = 46;
  HTTP_QUERY_CONTENT_DISPOSITION              = 47;

{ HTTP 1.1 defined headers }

  HTTP_QUERY_AGE                              = 48;
  HTTP_QUERY_CACHE_CONTROL                    = 49;
  HTTP_QUERY_CONTENT_BASE                     = 50;
  HTTP_QUERY_CONTENT_LOCATION                 = 51;
  HTTP_QUERY_CONTENT_MD5                      = 52;
  HTTP_QUERY_CONTENT_RANGE                    = 53;
  HTTP_QUERY_ETAG                             = 54;
  HTTP_QUERY_HOST                             = 55;
  HTTP_QUERY_IF_MATCH                         = 56;
  HTTP_QUERY_IF_NONE_MATCH                    = 57;
  HTTP_QUERY_IF_RANGE                         = 58;
  HTTP_QUERY_IF_UNMODIFIED_SINCE              = 59;
  HTTP_QUERY_MAX_FORWARDS                     = 60;
  HTTP_QUERY_PROXY_AUTHORIZATION              = 61;
  HTTP_QUERY_RANGE                            = 62;
  HTTP_QUERY_TRANSFER_ENCODING                = 63;
  HTTP_QUERY_UPGRADE                          = 64;
  HTTP_QUERY_VARY                             = 65;
  HTTP_QUERY_VIA                              = 66;
  HTTP_QUERY_WARNING                          = 67;
  HTTP_QUERY_MAX                              = 67;

{ HTTP_QUERY_CUSTOM - if this special value is supplied as the dwInfoLevel }
{ parameter of HttpQueryInfo then the lpBuffer parameter contains the name }
{ of the header we are to query }
  HTTP_QUERY_CUSTOM                           = 65535;

{ HTTP_QUERY_FLAG_REQUEST_HEADERS - if this bit is set in the dwInfoLevel }
{ parameter of HttpQueryInfo then the request headers will be queried for the }
{ request information }
  HTTP_QUERY_FLAG_REQUEST_HEADERS             = $80000000;

{ HTTP_QUERY_FLAG_SYSTEMTIME - if this bit is set in the dwInfoLevel parameter }
{ of HttpQueryInfo AND the header being queried contains date information, }
{ e.g. the "Expires:" header then lpBuffer will contain a SYSTEMTIME structure }
{ containing the date and time information converted from the header string }
  HTTP_QUERY_FLAG_SYSTEMTIME                  = $40000000;

{ HTTP_QUERY_FLAG_NUMBER - if this bit is set in the dwInfoLevel parameter of }
{ HttpQueryInfo, then the value of the header will be converted to a number }
{ before being returned to the caller, if applicable }
  HTTP_QUERY_FLAG_NUMBER                      = $20000000;

{ HTTP_QUERY_FLAG_COALESCE - combine the values from several headers of the }
{ same name into the output buffer }
  HTTP_QUERY_FLAG_COALESCE                    = $10000000;

  HTTP_QUERY_MODIFIER_FLAGS_MASK              = HTTP_QUERY_FLAG_REQUEST_HEADERS or
                                                HTTP_QUERY_FLAG_SYSTEMTIME or
                                                HTTP_QUERY_FLAG_NUMBER or
                                                HTTP_QUERY_FLAG_COALESCE;

  HTTP_QUERY_HEADER_MASK                      = not HTTP_QUERY_MODIFIER_FLAGS_MASK;

{  HTTP Response Status Codes: }
  HTTP_STATUS_CONTINUE            = 100;    { OK to continue with request }
  HTTP_STATUS_SWITCH_PROTOCOLS    = 101;    { server has switched protocols in upgrade header }
  HTTP_STATUS_OK                  = 200;    { request completed }
  HTTP_STATUS_CREATED             = 201;    { object created, reason = new URI }
  HTTP_STATUS_ACCEPTED            = 202;    { async completion (TBS) }
  HTTP_STATUS_PARTIAL             = 203;    { partial completion }
  HTTP_STATUS_NO_CONTENT          = 204;    { no info to return }
  HTTP_STATUS_RESET_CONTENT       = 205;    { request completed, but clear form }
  HTTP_STATUS_PARTIAL_CONTENT     = 206;    { partial GET furfilled }
  HTTP_STATUS_AMBIGUOUS           = 300;    { server couldn't decide what to return }
  HTTP_STATUS_MOVED               = 301;    { object permanently moved }
  HTTP_STATUS_REDIRECT            = 302;    { object temporarily moved }
  HTTP_STATUS_REDIRECT_METHOD     = 303;    { redirection w/ new access method }
  HTTP_STATUS_NOT_MODIFIED        = 304;    { if-modified-since was not modified }
  HTTP_STATUS_USE_PROXY           = 305;    { redirection to proxy, location header specifies proxy to use }
  HTTP_STATUS_REDIRECT_KEEP_VERB  = 307;    { HTTP/1.1: keep same verb }
  HTTP_STATUS_BAD_REQUEST         = 400;    { invalid syntax }
  HTTP_STATUS_DENIED              = 401;    { access denied }
  HTTP_STATUS_PAYMENT_REQ         = 402;    { payment required }
  HTTP_STATUS_FORBIDDEN           = 403;    { request forbidden }
  HTTP_STATUS_NOT_FOUND           = 404;    { object not found }
  HTTP_STATUS_BAD_METHOD          = 405;    { method is not allowed }
  HTTP_STATUS_NONE_ACCEPTABLE     = 406;    { no response acceptable to client found }
  HTTP_STATUS_PROXY_AUTH_REQ      = 407;    { proxy authentication required }
  HTTP_STATUS_REQUEST_TIMEOUT     = 408;    { server timed out waiting for request }
  HTTP_STATUS_CONFLICT            = 409;    { user should resubmit with more info }
  HTTP_STATUS_GONE                = 410;    { the resource is no longer available }
  HTTP_STATUS_AUTH_REFUSED        = 411;    { couldn't authorize client }
  HTTP_STATUS_PRECOND_FAILED      = 412;    { precondition given in request failed }
  HTTP_STATUS_REQUEST_TOO_LARGE   = 413;    { request entity was too large }
  HTTP_STATUS_URI_TOO_LONG        = 414;    { request URI too long }
  HTTP_STATUS_UNSUPPORTED_MEDIA   = 415;    { unsupported media type }
  HTTP_STATUS_SERVER_ERROR        = 500;    { internal server error }
  HTTP_STATUS_NOT_SUPPORTED       = 501;    { required not supported }
  HTTP_STATUS_BAD_GATEWAY         = 502;    { error response received from gateway }
  HTTP_STATUS_SERVICE_UNAVAIL     = 503;    { temporarily overloaded }
  HTTP_STATUS_GATEWAY_TIMEOUT     = 504;    { timed out waiting for gateway }
  HTTP_STATUS_VERSION_NOT_SUP     = 505;    { HTTP version not supported }
  HTTP_STATUS_FIRST               = HTTP_STATUS_CONTINUE;
  HTTP_STATUS_LAST                = HTTP_STATUS_VERSION_NOT_SUP;

{ prototypes }

function HttpOpenRequest(hConnect: HINTERNET; lpszVerb: string;
  lpszObjectName: string; lpszVersion: string; lpszReferrer: string;
  lplpszAcceptTypes: string; dwFlags: string;
  dwContext: DWORD): HINTERNET; overload;
function HttpOpenRequest(hConnect: HINTERNET; lpszVerb: string;
  lpszObjectName: string; lpszVersion: string; lpszReferrer: string;
  lplpszAcceptTypes: IntPtr; dwFlags: IntPtr;
  dwContext: DWORD): HINTERNET; overload;
function HttpOpenRequest(hConnect: HINTERNET; lpszVerb: string;
  lpszObjectName: string; lpszVersion: string; lpszReferrer: string;
  lplpszAcceptTypes: string; dwFlags: IntPtr;
  dwContext: DWORD): HINTERNET; overload;
function HttpOpenRequest(hConnect: HINTERNET; lpszVerb: string;
  lpszObjectName: string; lpszVersion: string; lpszReferrer: string;
  lplpszAcceptTypes: IntPtr; dwFlags: string;
  dwContext: DWORD): HINTERNET; overload;
function HttpOpenRequestA(hConnect: HINTERNET; lpszVerb: string;
  lpszObjectName: string; lpszVersion: string; lpszReferrer: string;
  lplpszAcceptTypes: string; dwFlags: DWORD;
  dwContext: DWORD): HINTERNET; 
function HttpOpenRequestW(hConnect: HINTERNET; lpszVerb: string;
  lpszObjectName: string; lpszVersion: string; lpszReferrer: string;
  lplpszAcceptTypes: string; dwFlags: DWORD;
  dwContext: DWORD): HINTERNET; 

function HttpAddRequestHeaders(hRequest: HINTERNET; lpszHeaders: string;
  dwHeadersLength: DWORD; dwModifiers: DWORD): BOOL;
function HttpAddRequestHeadersA(hRequest: HINTERNET; lpszHeaders: string;
  dwHeadersLength: DWORD; dwModifiers: DWORD): BOOL; 
function HttpAddRequestHeadersW(hRequest: HINTERNET; lpszHeaders: string;
  dwHeadersLength: DWORD; dwModifiers: DWORD): BOOL; 

const
{ values for dwModifiers parameter of HttpAddRequestHeaders }

  HTTP_ADDREQ_INDEX_MASK          = $0000FFFF;
  HTTP_ADDREQ_FLAGS_MASK          = $FFFF0000;

{ HTTP_ADDREQ_FLAG_ADD_IF_NEW - the header will only be added if it doesn't }
{ already exist }

  HTTP_ADDREQ_FLAG_ADD_IF_NEW     = $10000000;

{ HTTP_ADDREQ_FLAG_ADD - if HTTP_ADDREQ_FLAG_REPLACE is set but the header is }
{ not found then if this flag is set, the header is added anyway, so long as }
{ there is a valid header-value }

  HTTP_ADDREQ_FLAG_ADD            = $20000000;

{ HTTP_ADDREQ_FLAG_COALESCE - coalesce headers with same name. e.g. }
{ "Accept: text/*" and "Accept: audio/*" with this flag results in a single }
{ header: "Accept: text/*, audio/*" }

  HTTP_ADDREQ_FLAG_COALESCE_WITH_COMMA           = $40000000;
  HTTP_ADDREQ_FLAG_COALESCE_WITH_SEMICOLON       = $01000000;
  HTTP_ADDREQ_FLAG_COALESCE                      = HTTP_ADDREQ_FLAG_COALESCE_WITH_COMMA;

{ HTTP_ADDREQ_FLAG_REPLACE - replaces the specified header. Only one header can }
{ be supplied in the buffer. If the header to be replaced is not the first }
{ in a list of headers with the same name, then the relative index should be }
{ supplied in the low 8 bits of the dwModifiers parameter. If the header-value }
{ part is missing, then the header is removed }

  HTTP_ADDREQ_FLAG_REPLACE        = $80000000;

function HttpSendRequest(hRequest: HINTERNET; lpszHeaders: string;
  dwHeadersLength: DWORD; lpOptional: IntPtr;
  dwOptionalLength: DWORD): BOOL; overload;
function HttpSendRequest(hRequest: HINTERNET; lpszHeaders: IntPtr;
  dwHeadersLength: DWORD; lpOptional: IntPtr;
  dwOptionalLength: DWORD): BOOL; overload;
function HttpSendRequestA(hRequest: HINTERNET; lpszHeaders: string;
  dwHeadersLength: DWORD; lpOptional: IntPtr;
  dwOptionalLength: DWORD): BOOL;
function HttpSendRequestW(hRequest: HINTERNET; lpszHeaders: string;
  dwHeadersLength: DWORD; lpOptional: IntPtr;
  dwOptionalLength: DWORD): BOOL; 

function HttpSendRequestEx(hRequest: HINTERNET; const lpBuffersIn: TInternetBuffers;
  out lpBuffersOut: TInternetBuffers; dwFlags: DWORD; dwContext: DWORD): BOOL; overload;
function HttpSendRequestEx(hRequest: HINTERNET; lpBuffersIn: IntPtr;
  lpBuffersOut: IntPtr; dwFlags: DWORD; dwContext: DWORD): BOOL; overload;
function HttpSendRequestEx(hRequest: HINTERNET; const lpBuffersIn: TInternetBuffers;
  lpBuffersOut: IntPtr; dwFlags: DWORD; dwContext: DWORD): BOOL; overload;
function HttpSendRequestEx(hRequest: HINTERNET; lpBuffersIn: IntPtr;
  out lpBuffersOut: TInternetBuffers; dwFlags: DWORD; dwContext: DWORD): BOOL; overload;
function HttpSendRequestExA(hRequest: HINTERNET; const lpBuffersIn: TInternetBuffers;
  out lpBuffersOut: TInternetBuffers; dwFlags: DWORD; dwContext: DWORD): BOOL;
function HttpSendRequestExW(hRequest: HINTERNET; const lpBuffersIn: TInternetBuffers;
  out lpBuffersOut: TInternetBuffers; dwFlags: DWORD; dwContext: DWORD): BOOL;

{ flags for HttpSendRequestEx(), HttpEndRequest() }
const
  HSR_ASYNC       = WININET_API_FLAG_ASYNC;          { force async }
  HSR_SYNC        = WININET_API_FLAG_SYNC;           { force sync }
  HSR_USE_CONTEXT = WININET_API_FLAG_USE_CONTEXT;    { use dwContext value }
  HSR_INITIATE    = $00000008;                       { iterative operation (completed by HttpEndRequest) }
  HSR_DOWNLOAD    = $00000010;                       { download to file }
  HSR_CHUNKED     = $00000020;                       { operation is send of chunked data }

function HttpEndRequest(hRequest: HINTERNET;
  lpBuffersOut: IntPtr; dwFlags: DWORD;
  dwContext: DWORD): BOOL;
function HttpEndRequestA(hRequest: HINTERNET;
  lpBuffersOut: IntPtr; dwFlags: DWORD;
  dwContext: DWORD): BOOL; 
function HttpEndRequestW(hRequest: HINTERNET;
  lpBuffersOut: IntPtr; dwFlags: DWORD;
  dwContext: DWORD): BOOL; 

function HttpQueryInfo(hRequest: HINTERNET; dwInfoLevel: DWORD;
  lpvBuffer: IntPtr; [in] var lpdwBufferLength: DWORD; var lpdwReserved: DWORD): BOOL;
function HttpQueryInfoA(hRequest: HINTERNET; dwInfoLevel: DWORD;
  lpvBuffer: IntPtr; [in] var lpdwBufferLength: DWORD; var lpdwReserved: DWORD): BOOL;
function HttpQueryInfoW(hRequest: HINTERNET; dwInfoLevel: DWORD;
  lpvBuffer: IntPtr; [in] var lpdwBufferLength: DWORD; var lpdwReserved: DWORD): BOOL; 

{ Cookie APIs }

function InternetSetCookie(lpszUrl, lpszCookieName,
  lpszCookieData: string): BOOL;
function InternetSetCookieA(lpszUrl, lpszCookieName,
  lpszCookieData: string): BOOL; 
function InternetSetCookieW(lpszUrl, lpszCookieName,
  lpszCookieData: string): BOOL; 

function InternetGetCookie(lpszUrl, lpszCookieName,
  lpszCookieData: StringBuilder; var lpdwSize: DWORD): BOOL;
function InternetGetCookieA(lpszUrl, lpszCookieName,
  lpszCookieData: StringBuilder; var lpdwSize: DWORD): BOOL; 
function InternetGetCookieW(lpszUrl, lpszCookieName,
  lpszCookieData: StringBuilder; var lpdwSize: DWORD): BOOL; 

function InternetAttemptConnect(dwReserved: DWORD): DWORD;

function InternetCheckConnection(lpszUrl: string; dwFlags: DWORD;
    dwReserved: DWORD): BOOL;
function InternetCheckConnectionA(lpszUrl: string; dwFlags: DWORD;
    dwReserved: DWORD): BOOL;
function InternetCheckConnectionW(lpszUrl: string; dwFlags: DWORD;
    dwReserved: DWORD): BOOL; 

{ Internet UI }

{ InternetErrorDlg - Provides UI for certain Errors. }
const
  FLAGS_ERROR_UI_FILTER_FOR_ERRORS            = $01;
  FLAGS_ERROR_UI_FLAGS_CHANGE_OPTIONS         = $02;
  FLAGS_ERROR_UI_FLAGS_GENERATE_DATA          = $04;
  FLAGS_ERROR_UI_FLAGS_NO_UI                  = $08;
  FLAGS_ERROR_UI_SERIALIZE_DIALOGS            = $10;

function InternetAuthNotifyCallback(
    dwContext: DWORD;     { as passed to InternetErrorDlg }
    dwReturn: DWORD;      { error code: success, resend, or cancel }
    lpReserved: IntPtr    { reserved: will be set to null }
): DWORD;

type
  PFN_AUTH_NOTIFY = function(dwContext:DWORD; dwReturn:DWORD;
    lpReserved: IntPtr): DWORD;

function InternetErrorDlg(hWnd: HWND; hRequest: HINTERNET;
  dwError, dwFlags: DWORD; var lppvData: IntPtr): DWORD;

function InternetConfirmZoneCrossing(hWnd: HWND;
  szUrlPrev, szUrlNew: string; bPost: BOOL): DWORD;
function InternetConfirmZoneCrossingA(hWnd: HWND;
  szUrlPrev, szUrlNew: string; bPost: BOOL): DWORD;
function InternetConfirmZoneCrossingW(hWnd: HWND;
  szUrlPrev, szUrlNew: string; bPost: BOOL): DWORD;

const
{ Internet API error returns }

  INTERNET_ERROR_BASE                         = 12000;
  ERROR_INTERNET_OUT_OF_HANDLES               = INTERNET_ERROR_BASE + 1;
  ERROR_INTERNET_TIMEOUT                      = INTERNET_ERROR_BASE + 2;
  ERROR_INTERNET_EXTENDED_ERROR               = INTERNET_ERROR_BASE + 3;
  ERROR_INTERNET_INTERNAL_ERROR               = INTERNET_ERROR_BASE + 4;
  ERROR_INTERNET_INVALID_URL                  = INTERNET_ERROR_BASE + 5;
  ERROR_INTERNET_UNRECOGNIZED_SCHEME          = INTERNET_ERROR_BASE + 6;
  ERROR_INTERNET_NAME_NOT_RESOLVED            = INTERNET_ERROR_BASE + 7;
  ERROR_INTERNET_PROTOCOL_NOT_FOUND           = INTERNET_ERROR_BASE + 8;
  ERROR_INTERNET_INVALID_OPTION               = INTERNET_ERROR_BASE + 9;
  ERROR_INTERNET_BAD_OPTION_LENGTH            = INTERNET_ERROR_BASE + 10;
  ERROR_INTERNET_OPTION_NOT_SETTABLE          = INTERNET_ERROR_BASE + 11;
  ERROR_INTERNET_SHUTDOWN                     = INTERNET_ERROR_BASE + 12;
  ERROR_INTERNET_INCORRECT_USER_NAME          = INTERNET_ERROR_BASE + 13;
  ERROR_INTERNET_INCORRECT_PASSWORD           = INTERNET_ERROR_BASE + 14;
  ERROR_INTERNET_LOGIN_FAILURE                = INTERNET_ERROR_BASE + 15;
  ERROR_INTERNET_INVALID_OPERATION            = INTERNET_ERROR_BASE + 16;
  ERROR_INTERNET_OPERATION_CANCELLED          = INTERNET_ERROR_BASE + 17;
  ERROR_INTERNET_INCORRECT_HANDLE_TYPE        = INTERNET_ERROR_BASE + 18;
  ERROR_INTERNET_INCORRECT_HANDLE_STATE       = INTERNET_ERROR_BASE + 19;
  ERROR_INTERNET_NOT_PROXY_REQUEST            = INTERNET_ERROR_BASE + 20;
  ERROR_INTERNET_REGISTRY_VALUE_NOT_FOUND     = INTERNET_ERROR_BASE + 21;
  ERROR_INTERNET_BAD_REGISTRY_PARAMETER       = INTERNET_ERROR_BASE + 22;
  ERROR_INTERNET_NO_DIRECT_ACCESS             = INTERNET_ERROR_BASE + 23;
  ERROR_INTERNET_NO_CONTEXT                   = INTERNET_ERROR_BASE + 24;
  ERROR_INTERNET_NO_CALLBACK                  = INTERNET_ERROR_BASE + 25;
  ERROR_INTERNET_REQUEST_PENDING              = INTERNET_ERROR_BASE + 26;
  ERROR_INTERNET_INCORRECT_FORMAT             = INTERNET_ERROR_BASE + 27;
  ERROR_INTERNET_ITEM_NOT_FOUND               = INTERNET_ERROR_BASE + 28;
  ERROR_INTERNET_CANNOT_CONNECT               = INTERNET_ERROR_BASE + 29;
  ERROR_INTERNET_CONNECTION_ABORTED           = INTERNET_ERROR_BASE + 30;
  ERROR_INTERNET_CONNECTION_RESET             = INTERNET_ERROR_BASE + 31;
  ERROR_INTERNET_FORCE_RETRY                  = INTERNET_ERROR_BASE + 32;
  ERROR_INTERNET_INVALID_PROXY_REQUEST        = INTERNET_ERROR_BASE + 33;
  ERROR_INTERNET_HANDLE_EXISTS                = INTERNET_ERROR_BASE + 36;
  ERROR_INTERNET_SEC_CERT_DATE_INVALID        = INTERNET_ERROR_BASE + 37;
  ERROR_INTERNET_SEC_CERT_CN_INVALID          = INTERNET_ERROR_BASE + 38;
  ERROR_INTERNET_HTTP_TO_HTTPS_ON_REDIR       = INTERNET_ERROR_BASE + 39;
  ERROR_INTERNET_HTTPS_TO_HTTP_ON_REDIR       = INTERNET_ERROR_BASE + 40;
  ERROR_INTERNET_MIXED_SECURITY               = INTERNET_ERROR_BASE + 41;
  ERROR_INTERNET_CHG_POST_IS_NON_SECURE       = INTERNET_ERROR_BASE + 42;
  ERROR_INTERNET_POST_IS_NON_SECURE           = INTERNET_ERROR_BASE + 43;
  ERROR_INTERNET_CLIENT_AUTH_CERT_NEEDED      = INTERNET_ERROR_BASE + 44;
  ERROR_INTERNET_INVALID_CA                   = INTERNET_ERROR_BASE + 45;
  ERROR_INTERNET_CLIENT_AUTH_NOT_SETUP        = INTERNET_ERROR_BASE + 46;
  ERROR_INTERNET_ASYNC_THREAD_FAILED          = INTERNET_ERROR_BASE + 47;
  ERROR_INTERNET_REDIRECT_SCHEME_CHANGE       = INTERNET_ERROR_BASE + 48;
  ERROR_INTERNET_DIALOG_PENDING               = INTERNET_ERROR_BASE + 49;
  ERROR_INTERNET_RETRY_DIALOG                 = INTERNET_ERROR_BASE + 50;
  ERROR_INTERNET_HTTPS_HTTP_SUBMIT_REDIR      = INTERNET_ERROR_BASE + 52;
  ERROR_INTERNET_INSERT_CDROM                 = INTERNET_ERROR_BASE + 53;

{ FTP API errors }

  ERROR_FTP_TRANSFER_IN_PROGRESS              = INTERNET_ERROR_BASE + 110;
  ERROR_FTP_DROPPED                           = INTERNET_ERROR_BASE + 111;
  ERROR_FTP_NO_PASSIVE_MODE                   = INTERNET_ERROR_BASE + 112;

{ gopher API errors }

  ERROR_GOPHER_PROTOCOL_ERROR                 = INTERNET_ERROR_BASE + 130;
  ERROR_GOPHER_NOT_FILE                       = INTERNET_ERROR_BASE + 131;
  ERROR_GOPHER_DATA_ERROR                     = INTERNET_ERROR_BASE + 132;
  ERROR_GOPHER_END_OF_DATA                    = INTERNET_ERROR_BASE + 133;
  ERROR_GOPHER_INVALID_LOCATOR                = INTERNET_ERROR_BASE + 134;
  ERROR_GOPHER_INCORRECT_LOCATOR_TYPE         = INTERNET_ERROR_BASE + 135;
  ERROR_GOPHER_NOT_GOPHER_PLUS                = INTERNET_ERROR_BASE + 136;
  ERROR_GOPHER_ATTRIBUTE_NOT_FOUND            = INTERNET_ERROR_BASE + 137;
  ERROR_GOPHER_UNKNOWN_LOCATOR                = INTERNET_ERROR_BASE + 138;

{ HTTP API errors }

  ERROR_HTTP_HEADER_NOT_FOUND                 = INTERNET_ERROR_BASE + 150;
  ERROR_HTTP_DOWNLEVEL_SERVER                 = INTERNET_ERROR_BASE + 151;
  ERROR_HTTP_INVALID_SERVER_RESPONSE          = INTERNET_ERROR_BASE + 152;
  ERROR_HTTP_INVALID_HEADER                   = INTERNET_ERROR_BASE + 153;
  ERROR_HTTP_INVALID_QUERY_REQUEST            = INTERNET_ERROR_BASE + 154;
  ERROR_HTTP_HEADER_ALREADY_EXISTS            = INTERNET_ERROR_BASE + 155;
  ERROR_HTTP_REDIRECT_FAILED                  = INTERNET_ERROR_BASE + 156;
  ERROR_HTTP_NOT_REDIRECTED                   = INTERNET_ERROR_BASE + 160;
  ERROR_HTTP_COOKIE_NEEDS_CONFIRMATION        = INTERNET_ERROR_BASE + 161;
  ERROR_HTTP_COOKIE_DECLINED                  = INTERNET_ERROR_BASE + 162;
  ERROR_HTTP_REDIRECT_NEEDS_CONFIRMATION      = INTERNET_ERROR_BASE + 168;

{ additional Internet API error codes }
  ERROR_INTERNET_SECURITY_CHANNEL_ERROR       = INTERNET_ERROR_BASE + 157;
  ERROR_INTERNET_UNABLE_TO_CACHE_FILE         = INTERNET_ERROR_BASE + 158;
  ERROR_INTERNET_TCPIP_NOT_INSTALLED          = INTERNET_ERROR_BASE + 159;
  ERROR_INTERNET_DISCONNECTED                 = INTERNET_ERROR_BASE + 163;
  ERROR_INTERNET_SERVER_UNREACHABLE           = INTERNET_ERROR_BASE + 164;
  ERROR_INTERNET_PROXY_SERVER_UNREACHABLE     = INTERNET_ERROR_BASE + 165;
  ERROR_INTERNET_BAD_AUTO_PROXY_SCRIPT        = INTERNET_ERROR_BASE + 166;
  ERROR_INTERNET_UNABLE_TO_DOWNLOAD_SCRIPT    = INTERNET_ERROR_BASE + 167;
  ERROR_INTERNET_SEC_INVALID_CERT             = INTERNET_ERROR_BASE + 169;
  ERROR_INTERNET_SEC_CERT_REVOKED             = INTERNET_ERROR_BASE + 170;

{ InternetAutodial specific errors }

  ERROR_INTERNET_FAILED_DUETOSECURITYCHECK    = INTERNET_ERROR_BASE + 171;
  INTERNET_ERROR_LAST                         = ERROR_INTERNET_FAILED_DUETOSECURITYCHECK;

{ URLCACHE APIs }

{ datatype definitions. }

{ cache entry type flags. }

  NORMAL_CACHE_ENTRY          = $00000001;
  STABLE_CACHE_ENTRY          = $00000002;
  STICKY_CACHE_ENTRY          = $00000004;
  COOKIE_CACHE_ENTRY          = $00100000;
  URLHISTORY_CACHE_ENTRY      = $00200000;
  TRACK_OFFLINE_CACHE_ENTRY   = $00000010;
  TRACK_ONLINE_CACHE_ENTRY    = $00000020;
  SPARSE_CACHE_ENTRY          = $00010000;
  OCX_CACHE_ENTRY             = $00020000;

  URLCACHE_FIND_DEFAULT_FILTER = NORMAL_CACHE_ENTRY or
                                 COOKIE_CACHE_ENTRY or
                                 URLHISTORY_CACHE_ENTRY or
                                 TRACK_OFFLINE_CACHE_ENTRY or
                                 TRACK_ONLINE_CACHE_ENTRY or
                                 STICKY_CACHE_ENTRY;

type
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Auto)]
  INTERNET_CACHE_ENTRY_INFO = record
    dwStructSize: DWORD;         { version of cache system. ?? do we need this for all entries? }
    [MarshalAs(UnmanagedType.LPStr)]
    lpszSourceUrlName: string;   { embedded pointer to the URL name string. }
    [MarshalAs(UnmanagedType.LPTStr)]
    lpszLocalFileName: string;   { embedded pointer to the local file name. }
    CacheEntryType: DWORD;       { cache type bit mask. }
    dwUseCount: DWORD;           { current users count of the cache entry. }
    dwHitRate: DWORD;            { num of times the cache entry was retrieved. }
    dwSizeLow: DWORD;            { low DWORD of the file size. }
    dwSizeHigh: DWORD;           { high DWORD of the file size. }
    LastModifiedTime: TFileTime; { last modified time of the file in GMT format. }
    ExpireTime: TFileTime;       { expire time of the file in GMT format }
    LastAccessTime: TFileTime;   { last accessed time in GMT format }
    LastSyncTime: TFileTime;     { last time the URL was synchronized }
                                 { with the source }
    lpHeaderInfo: IntPtr;        { embedded pointer to the header info. }
    dwHeaderInfoSize: DWORD;     { size of the above header. }
    [MarshalAs(UnmanagedType.LPTStr)]
    lpszFileExtension: string;   { File extension used to retrive the urldata as a file. }
    dwReserved: DWORD;           { reserved for future use. }
  end;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Ansi)]
  INTERNET_CACHE_ENTRY_INFOA = record
    dwStructSize: DWORD;         { version of cache system. ?? do we need this for all entries? }
    [MarshalAs(UnmanagedType.LPStr)]
    lpszSourceUrlName: string;   { embedded pointer to the URL name string. }
    [MarshalAs(UnmanagedType.LPTStr)]
    lpszLocalFileName: string;   { embedded pointer to the local file name. }
    CacheEntryType: DWORD;       { cache type bit mask. }
    dwUseCount: DWORD;           { current users count of the cache entry. }
    dwHitRate: DWORD;            { num of times the cache entry was retrieved. }
    dwSizeLow: DWORD;            { low DWORD of the file size. }
    dwSizeHigh: DWORD;           { high DWORD of the file size. }
    LastModifiedTime: TFileTime; { last modified time of the file in GMT format. }
    ExpireTime: TFileTime;       { expire time of the file in GMT format }
    LastAccessTime: TFileTime;   { last accessed time in GMT format }
    LastSyncTime: TFileTime;     { last time the URL was synchronized }
                                 { with the source }
    lpHeaderInfo: IntPtr;        { embedded pointer to the header info. }
    dwHeaderInfoSize: DWORD;     { size of the above header. }
    [MarshalAs(UnmanagedType.LPTStr)]
    lpszFileExtension: string;   { File extension used to retrive the urldata as a file. }
    dwReserved: DWORD;           { reserved for future use. }
  end;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Unicode)]
  INTERNET_CACHE_ENTRY_INFOW = record
    dwStructSize: DWORD;         { version of cache system. ?? do we need this for all entries? }
    [MarshalAs(UnmanagedType.LPStr)]
    lpszSourceUrlName: string;   { embedded pointer to the URL name string. }
    [MarshalAs(UnmanagedType.LPTStr)]
    lpszLocalFileName: string;   { embedded pointer to the local file name. }
    CacheEntryType: DWORD;       { cache type bit mask. }
    dwUseCount: DWORD;           { current users count of the cache entry. }
    dwHitRate: DWORD;            { num of times the cache entry was retrieved. }
    dwSizeLow: DWORD;            { low DWORD of the file size. }
    dwSizeHigh: DWORD;           { high DWORD of the file size. }
    LastModifiedTime: TFileTime; { last modified time of the file in GMT format. }
    ExpireTime: TFileTime;       { expire time of the file in GMT format }
    LastAccessTime: TFileTime;   { last accessed time in GMT format }
    LastSyncTime: TFileTime;     { last time the URL was synchronized }
                                 { with the source }
    lpHeaderInfo: IntPtr;        { embedded pointer to the header info. }
    dwHeaderInfoSize: DWORD;     { size of the above header. }
    [MarshalAs(UnmanagedType.LPTStr)]
    lpszFileExtension: string;   { File extension used to retrive the urldata as a file. }
    dwReserved: DWORD;           { reserved for future use. }
  end;
  TInternetCacheEntryInfo = INTERNET_CACHE_ENTRY_INFO;
  TInternetCacheEntryInfoA = INTERNET_CACHE_ENTRY_INFOA;
  TInternetCacheEntryInfoW = INTERNET_CACHE_ENTRY_INFOW;

{ Cache APIs }

function CreateUrlCacheEntry(lpszUrlName: string;
  dwExpectedFileSize: DWORD; lpszFileExtension: string;
  lpszFileName: StringBuilder; dwReserved: DWORD): BOOL;
function CreateUrlCacheEntryA(lpszUrlName: string;
  dwExpectedFileSize: DWORD; lpszFileExtension: string;
  lpszFileName: StringBuilder; dwReserved: DWORD): BOOL; 
function CreateUrlCacheEntryW(lpszUrlName: string;
  dwExpectedFileSize: DWORD; lpszFileExtension: string;
  lpszFileName: StringBuilder; dwReserved: DWORD): BOOL;

function CommitUrlCacheEntry(lpszUrlName, lpszLocalFileName: string;
  ExpireTime, LastModifiedTime: TFileTime; CacheEntryType: DWORD;
  const lpHeaderInfo: TInternetCacheEntryInfo; dwHeaderSize: DWORD;
  lpszFileExtension: IntPtr; lpszOriginalUrl: string): BOOL; overload;
function CommitUrlCacheEntry(lpszUrlName, lpszLocalFileName: string;
  ExpireTime, LastModifiedTime: TFileTime; CacheEntryType: DWORD;
  lpHeaderInfo: IntPtr; dwHeaderSize: DWORD; lpszFileExtension: IntPtr;
  lpszOriginalUrl: string): BOOL; overload;
function CommitUrlCacheEntryA(lpszUrlName, lpszLocalFileName: string;
  ExpireTime, LastModifiedTime: TFileTime;  CacheEntryType: DWORD;
  const lpHeaderInfo: TInternetCacheEntryInfo; dwHeaderSize: DWORD; lpszFileExtension: IntPtr;
  lpszOriginalUrl: string): BOOL;
function CommitUrlCacheEntryW(lpszUrlName, lpszLocalFileName: string;
  ExpireTime, LastModifiedTime: TFileTime;  CacheEntryType: DWORD;
  const lpHeaderInfo: TInternetCacheEntryInfo; dwHeaderSize: DWORD; lpszFileExtension: IntPtr;
  lpszOriginalUrl: string): BOOL; 

function RetrieveUrlCacheEntryFile(lpszUrlName: string;
  out lpCacheEntryInfo: TInternetCacheEntryInfo;
  var lpdwCacheEntryInfoBufferSize: DWORD;
  dwReserved: DWORD): BOOL;
function RetrieveUrlCacheEntryFileA(lpszUrlName: string;
  out lpCacheEntryInfo: TInternetCacheEntryInfo;
  var lpdwCacheEntryInfoBufferSize: DWORD;
  dwReserved: DWORD): BOOL;
function RetrieveUrlCacheEntryFileW(lpszUrlName: string;
  out lpCacheEntryInfo: TInternetCacheEntryInfo;
  var lpdwCacheEntryInfoBufferSize: DWORD;
  dwReserved: DWORD): BOOL; 

function UnlockUrlCacheEntryFile(lpszUrlName: string;
  dwReserved: DWORD): BOOL;

function RetrieveUrlCacheEntryStream(lpszUrlName: string;
  out lpCacheEntryInfo: TInternetCacheEntryInfo;
  var lpdwCacheEntryInfoBufferSize: DWORD; fRandomRead: BOOL;
  dwReserved: DWORD): THandle;
function RetrieveUrlCacheEntryStreamA(lpszUrlName: string;
  out lpCacheEntryInfo: TInternetCacheEntryInfo;
  var lpdwCacheEntryInfoBufferSize: DWORD; fRandomRead: BOOL;
  dwReserved: DWORD): THandle;
function RetrieveUrlCacheEntryStreamW(lpszUrlName: string;
  out lpCacheEntryInfo: TInternetCacheEntryInfo;
  var lpdwCacheEntryInfoBufferSize: DWORD; fRandomRead: BOOL;
  dwReserved: DWORD): THandle;

function ReadUrlCacheEntryStream(hUrlCacheStream: THandle;
  dwLocation: DWORD; [out] lpBuffer: TBytes;
  var lpdwLen: DWORD; Reserved: DWORD): BOOL;

function UnlockUrlCacheEntryStream(hUrlCacheStream: THandle;
  Reserved: DWORD): BOOL;

function GetUrlCacheEntryInfo(lpszUrlName: string;
  out lpCacheEntryInfo: TInternetCacheEntryInfo;
  var lpdwCacheEntryInfoBufferSize: DWORD): BOOL;
function GetUrlCacheEntryInfoA(lpszUrlName: string;
  out lpCacheEntryInfo: TInternetCacheEntryInfo;
  var lpdwCacheEntryInfoBufferSize: DWORD): BOOL; 
function GetUrlCacheEntryInfoW(lpszUrlName: string;
  out lpCacheEntryInfo: TInternetCacheEntryInfo;
  var lpdwCacheEntryInfoBufferSize: DWORD): BOOL; 

function GetUrlCacheEntryInfoEx(
    lpszUrl: string;
    out lpCacheEntryInfo: TInternetCacheEntryInfo;
    var lpdwCacheEntryInfoBufSize: DWORD;
    lpszReserved: IntPtr; { must pass nil }
    lpdwReserved: IntPtr; { must pass nil }
    lpReserved: IntPtr; { must pass nil }
    dwFlags: DWORD { reserved }
    ): BOOL;
function GetUrlCacheEntryInfoExA(
    lpszUrl: string;
    out lpCacheEntryInfo: TInternetCacheEntryInfo;
    var lpdwCacheEntryInfoBufSize: DWORD;
    lpszReserved: IntPtr; { must pass nil }
    lpdwReserved: IntPtr; { must pass nil }
    lpReserved: IntPtr; { must pass nil }
    dwFlags: DWORD { reserved }
    ): BOOL; 
function GetUrlCacheEntryInfoExW(
    lpszUrl: string;
    out lpCacheEntryInfo: TInternetCacheEntryInfo;
    var lpdwCacheEntryInfoBufSize: DWORD;
    lpszReserved: IntPtr; { must pass nil }
    lpdwReserved: IntPtr; { must pass nil }
    lpReserved: IntPtr; { must pass nil }
    dwFlags: DWORD { reserved }
    ): BOOL;

const
  CACHE_ENTRY_ATTRIBUTE_FC        = $00000004;
  CACHE_ENTRY_HITRATE_FC          = $00000010;
  CACHE_ENTRY_MODTIME_FC          = $00000040;
  CACHE_ENTRY_EXPTIME_FC          = $00000080;
  CACHE_ENTRY_ACCTIME_FC          = $00000100;
  CACHE_ENTRY_SYNCTIME_FC         = $00000200;
  CACHE_ENTRY_HEADERINFO_FC       = $00000400;
  CACHE_ENTRY_EXEMPT_DELTA_FC     = $00000800;

function SetUrlCacheEntryInfo(lpszUrlName: string;
  const lpCacheEntryInfo: TInternetCacheEntryInfo;
  dwFieldControl: DWORD): BOOL;
function SetUrlCacheEntryInfoA(lpszUrlName: string;
  const lpCacheEntryInfo: TInternetCacheEntryInfo;
  dwFieldControl: DWORD): BOOL; 
function SetUrlCacheEntryInfoW(lpszUrlName: string;
  const lpCacheEntryInfo: TInternetCacheEntryInfo;
  dwFieldControl: DWORD): BOOL; 

type
  GROUPID = Int64;

function CreateUrlCacheGroup(dwFlags: DWORD;
  lpReserved: IntPtr { must pass nill }
  ): Int64;

function DeleteUrlCacheGroup(GroupId: Int64;
    dwFlags: DWORD;    { must pass 0 }
    lpReserved: IntPtr { must pass nill }
    ): Bool;

{ Flags for SetUrlCacheEntryGroup }

const
  INTERNET_CACHE_GROUP_ADD      = 0;
  INTERNET_CACHE_GROUP_REMOVE   = 1;

function SetUrlCacheEntryGroup(lpszUrlName: string; dwFlags: DWORD;
  GroupId: Int64;
  pbGroupAttributes: IntPtr; { must pass nil }
  cbGroupAttributes: DWORD;  { must pass 0 }
  lpReserved: IntPtr         { must pass nil }
  ): Bool;

function FindFirstUrlCacheEntryEx(lpszUrlSearchPattern: IntPtr;
    dwFlags: DWORD;
    dwFilter: DWORD;
    GroupId: GROUPID;
    out lpFirstCacheEntryInfo: TInternetCacheEntryInfo;
    var lpdwFirstCacheEntryInfoBufferSize: DWORD;
    lpGroupAttributes: IntPtr;   { must pass nil }
    pcbGroupAttributes: IntPtr;  { must pass nil }
    lpReserved: IntPtr           { must pass nil }
    ): THandle;
function FindFirstUrlCacheEntryExA(lpszUrlSearchPattern: IntPtr;
    dwFlags: DWORD;
    dwFilter: DWORD;
    GroupId: GROUPID;
    out lpFirstCacheEntryInfo: TInternetCacheEntryInfo;
    var lpdwFirstCacheEntryInfoBufferSize: DWORD;
    lpGroupAttributes: IntPtr;   { must pass nil }
    pcbGroupAttributes: IntPtr;  { must pass nil }
    lpReserved: IntPtr           { must pass nil }
    ): THandle; 
function FindFirstUrlCacheEntryExW(lpszUrlSearchPattern: IntPtr;
    dwFlags: DWORD;
    dwFilter: DWORD;
    GroupId: GROUPID;
    out lpFirstCacheEntryInfo: TInternetCacheEntryInfo;
    var lpdwFirstCacheEntryInfoBufferSize: DWORD;
    lpGroupAttributes: IntPtr;   { must pass nil }
    pcbGroupAttributes: IntPtr;  { must pass nil }
    lpReserved: IntPtr           { must pass nil }
    ): THandle; 

function FindNextUrlCacheEntryEx(hEnumHandle: THANDLE;
    out lpFirstCacheEntryInfo: TInternetCacheEntryInfo;
    var lpdwFirstCacheEntryInfoBufferSize: DWORD;
    lpGroupAttributes: IntPtr;   { must pass nil }
    pcbGroupAttributes: IntPtr;  { must pass nil }
    lpReserved: IntPtr           { must pass nil }
    ): BOOL;
function FindNextUrlCacheEntryExA(hEnumHandle: THANDLE;
    out lpFirstCacheEntryInfo: TInternetCacheEntryInfo;
    var lpdwFirstCacheEntryInfoBufferSize: DWORD;
    lpGroupAttributes: IntPtr;   { must pass nil }
    pcbGroupAttributes: IntPtr;  { must pass nil }
    lpReserved: IntPtr           { must pass nil }
    ): BOOL; 
function FindNextUrlCacheEntryExW(hEnumHandle: THANDLE;
    out lpFirstCacheEntryInfo: TInternetCacheEntryInfo;
    var lpdwFirstCacheEntryInfoBufferSize: DWORD;
    lpGroupAttributes: IntPtr;   { must pass nil }
    pcbGroupAttributes: IntPtr;  { must pass nil }
    lpReserved: IntPtr           { must pass nil }
    ): BOOL; 

function FindFirstUrlCacheEntry(lpszUrlSearchPattern: string;
  out lpFirstCacheEntryInfo: TInternetCacheEntryInfo;
  var lpdwFirstCacheEntryInfoBufferSize: DWORD): THandle;
function FindFirstUrlCacheEntryA(lpszUrlSearchPattern: string;
  out lpFirstCacheEntryInfo: TInternetCacheEntryInfo;
  var lpdwFirstCacheEntryInfoBufferSize: DWORD): THandle; 
function FindFirstUrlCacheEntryW(lpszUrlSearchPattern: string;
  out lpFirstCacheEntryInfo: TInternetCacheEntryInfo;
  var lpdwFirstCacheEntryInfoBufferSize: DWORD): THandle; 

function FindNextUrlCacheEntry(hEnumHandle: THandle;
  out lpNextCacheEntryInfo: TInternetCacheEntryInfo;
  var lpdwNextCacheEntryInfoBufferSize: DWORD): BOOL;
function FindNextUrlCacheEntryA(hEnumHandle: THandle;
  out lpNextCacheEntryInfo: TInternetCacheEntryInfo;
  var lpdwNextCacheEntryInfoBufferSize: DWORD): BOOL; 
function FindNextUrlCacheEntryW(hEnumHandle: THandle;
  out lpNextCacheEntryInfo: TInternetCacheEntryInfo;
  var lpdwNextCacheEntryInfoBufferSize: DWORD): BOOL; 

function FindCloseUrlCache(hEnumHandle: THandle): BOOL;

function DeleteUrlCacheEntry(lpszUrlName: string): BOOL;

function InternetDial(hwndParent: HWND; lpszConnectoid: string; dwFlags: DWORD;
  out lpdwConnection: DWORD; dwReserved: DWORD): DWORD;

{ Flags for InternetDial - must not conflict with InternetAutodial flags }
{                          as they are valid here also.                  }
const
  INTERNET_DIAL_UNATTENDED       = $8000;

function InternetHangUp(dwConnection: DWORD; dwReserved: DWORD): DWORD;

const
  INTERENT_GOONLINE_REFRESH = $00000001;
  INTERENT_GOONLINE_MASK    = $00000001;

function InternetGoOnline(lpszURL: string; hwndParent: HWND;
  dwFlags: DWORD): BOOL;
function InternetGoOnlineA(lpszURL: string; hwndParent: HWND;
  dwFlags: DWORD): BOOL;
function InternetGoOnlineW(lpszURL: string; hwndParent: HWND;
  dwFlags: DWORD): BOOL;

function InternetAutodial(dwFlags: DWORD; dwReserved: DWORD): BOOL;

{ Flags for InternetAutodial }
const
  INTERNET_AUTODIAL_FORCE_ONLINE          = 1;
  INTERNET_AUTODIAL_FORCE_UNATTENDED      = 2;
  INTERNET_AUTODIAL_FAILIFSECURITYCHECK   = 4;
  INTERNET_AUTODIAL_FLAGS_MASK  = INTERNET_AUTODIAL_FORCE_ONLINE or
                                  INTERNET_AUTODIAL_FORCE_UNATTENDED or
                                  INTERNET_AUTODIAL_FAILIFSECURITYCHECK;

function InternetAutodialHangup(dwReserved: DWORD): BOOL;

function InternetGetConnectedState(out lpdwFlags: DWORD;
  dwReserved: DWORD): BOOL;

{ Flags for InternetGetConnectedState }
const
  INTERNET_CONNECTION_MODEM           = 1;
  INTERNET_CONNECTION_LAN             = 2;
  INTERNET_CONNECTION_PROXY           = 4;
  INTERNET_CONNECTION_MODEM_BUSY      = 8;
  INTERNET_RAS_INSTALLED              = 16;
  INTERNET_CONNECTION_OFFLINE         = 32;
  INTERNET_CONNECTION_CONFIGURED      = 64;

{ Custom dial handler functions }

{ Custom dial handler prototype }
type
  PFN_DIAL_HANDLER = function(A:HWND; B:string; C:DWORD; var D:DWORD): DWORD;

{ Flags for custom dial handler }
const
  INTERNET_CUSTOMDIAL_CONNECT         = 0;
  INTERNET_CUSTOMDIAL_UNATTENDED      = 1;
  INTERNET_CUSTOMDIAL_DISCONNECT      = 2;
  INTERNET_CUSTOMDIAL_SHOWOFFLINE     = 4;

{ Custom dial handler supported functionality flags }
  INTERNET_CUSTOMDIAL_SAFE_FOR_UNATTENDED = 1;
  INTERNET_CUSTOMDIAL_WILL_SUPPLY_STATE   = 2;
  INTERNET_CUSTOMDIAL_CAN_HANGUP          = 4;

function InternetSetDialState(lpszConnectoid: string; dwState: DWORD;
  dwReserved: DWORD): BOOL;

implementation

uses
  System.Security;

const
   winetdll = 'wininet.dll';

[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'CommitUrlCacheEntry')]
function CommitUrlCacheEntry(lpszUrlName, lpszLocalFileName: string;
  ExpireTime, LastModifiedTime: TFileTime; CacheEntryType: DWORD;
  const lpHeaderInfo: TInternetCacheEntryInfo; dwHeaderSize: DWORD;
  lpszFileExtension: IntPtr; lpszOriginalUrl: string): BOOL; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'CommitUrlCacheEntry')]
function CommitUrlCacheEntry(lpszUrlName, lpszLocalFileName: string;
  ExpireTime, LastModifiedTime: TFileTime; CacheEntryType: DWORD;
  lpHeaderInfo: IntPtr; dwHeaderSize: DWORD; lpszFileExtension: IntPtr;
  lpszOriginalUrl: string): BOOL; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CommitUrlCacheEntryA')]
function CommitUrlCacheEntryA; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'CommitUrlCacheEntryW')]
function CommitUrlCacheEntryW; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'CreateUrlCacheEntry')]
function CreateUrlCacheEntry; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CreateUrlCacheEntryA')]
function CreateUrlCacheEntryA; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'CreateUrlCacheEntryW')]
function CreateUrlCacheEntryW; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'DeleteUrlCacheEntry')]
function DeleteUrlCacheEntry; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'FindCloseUrlCache')]
function FindCloseUrlCache; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'FindFirstUrlCacheEntry')]
function FindFirstUrlCacheEntry; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'FindFirstUrlCacheEntryA')]
function FindFirstUrlCacheEntryA; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'FindFirstUrlCacheEntryW')]
function FindFirstUrlCacheEntryW; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'FindNextUrlCacheEntry')]
function FindNextUrlCacheEntry; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'FindNextUrlCacheEntryA')]
function FindNextUrlCacheEntryA; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'FindNextUrlCacheEntryW')]
function FindNextUrlCacheEntryW; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'FtpCommand')]
function FtpCommand; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'FtpCommandA')]
function FtpCommandA; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'FtpCommandW')]
function FtpCommandW; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'FtpCreateDirectory')]
function FtpCreateDirectory; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'FtpCreateDirectoryA')]
function FtpCreateDirectoryA; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'FtpCreateDirectoryW')]
function FtpCreateDirectoryW; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'FtpDeleteFile')]
function FtpDeleteFile; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'FtpDeleteFileA')]
function FtpDeleteFileA; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'FtpDeleteFileW')]
function FtpDeleteFileW; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'FtpFindFirstFile')]
function FtpFindFirstFile; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'FtpFindFirstFileA')]
function FtpFindFirstFileA; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'FtpFindFirstFileW')]
function FtpFindFirstFileW; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'FtpGetCurrentDirectory')]
function FtpGetCurrentDirectory; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'FtpGetCurrentDirectoryA')]
function FtpGetCurrentDirectoryA; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'FtpGetCurrentDirectoryW')]
function FtpGetCurrentDirectoryW; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'FtpGetFile')]
function FtpGetFile; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'FtpGetFileA')]
function FtpGetFileA; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'FtpGetFileW')]
function FtpGetFileW; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'FtpOpenFile')]
function FtpOpenFile; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'FtpOpenFileA')]
function FtpOpenFileA; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'FtpOpenFileW')]
function FtpOpenFileW; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'FtpPutFile')]
function FtpPutFile; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'FtpPutFileA')]
function FtpPutFileA; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'FtpPutFileW')]
function FtpPutFileW; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'FtpRemoveDirectory')]
function FtpRemoveDirectory; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'FtpRemoveDirectoryA')]
function FtpRemoveDirectoryA; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'FtpRemoveDirectoryW')]
function FtpRemoveDirectoryW; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'FtpRenameFile')]
function FtpRenameFile; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'FtpRenameFileA')]
function FtpRenameFileA; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'FtpRenameFileW')]
function FtpRenameFileW; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'FtpSetCurrentDirectory')]
function FtpSetCurrentDirectory; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'FtpSetCurrentDirectoryA')]
function FtpSetCurrentDirectoryA; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'FtpSetCurrentDirectoryW')]
function FtpSetCurrentDirectoryW; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'FtpGetFileSize')]
function FtpGetFileSize; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GetUrlCacheEntryInfo')]
function GetUrlCacheEntryInfo; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetUrlCacheEntryInfoA')]
function GetUrlCacheEntryInfoA; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'GetUrlCacheEntryInfoW')]
function GetUrlCacheEntryInfoW; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GopherCreateLocator')]
function GopherCreateLocator(lpszHost: string; nServerPort: INTERNET_PORT;
  lpszDisplayString: string; lpszSelectorString: string; dwGopherType: DWORD;
  lpszLocator: StringBuilder; var lpdwBufferLength: DWORD): BOOL; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GopherCreateLocator')]
function GopherCreateLocator(lpszHost: string; nServerPort: INTERNET_PORT;
  lpszDisplayString: IntPtr; lpszSelectorString: IntPtr; dwGopherType: DWORD;
  lpszLocator: StringBuilder; var lpdwBufferLength: DWORD): BOOL; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GopherCreateLocator')]
function GopherCreateLocator(lpszHost: string; nServerPort: INTERNET_PORT;
  lpszDisplayString: string; lpszSelectorString: IntPtr; dwGopherType: DWORD;
  lpszLocator: StringBuilder; var lpdwBufferLength: DWORD): BOOL; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GopherCreateLocator')]
function GopherCreateLocator(lpszHost: string; nServerPort: INTERNET_PORT;
  lpszDisplayString: IntPtr; lpszSelectorString: string; dwGopherType: DWORD;
  lpszLocator: StringBuilder; var lpdwBufferLength: DWORD): BOOL; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GopherCreateLocatorA')]
function GopherCreateLocatorA; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'GopherCreateLocatorW')]
function GopherCreateLocatorW; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GopherFindFirstFile')]
function GopherFindFirstFile; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GopherFindFirstFileA')]
function GopherFindFirstFileA; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'GopherFindFirstFileW')]
function GopherFindFirstFileW; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GopherGetAttribute')]
function GopherGetAttribute; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GopherGetAttributeA')]
function GopherGetAttributeA; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'GopherGetAttributeW')]
function GopherGetAttributeW; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GopherGetLocatorType')]
function GopherGetLocatorType; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GopherGetLocatorTypeA')]
function GopherGetLocatorTypeA; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'GopherGetLocatorTypeW')]
function GopherGetLocatorTypeW; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GopherOpenFile')]
function GopherOpenFile; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GopherOpenFileA')]
function GopherOpenFileA; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'GopherOpenFileW')]
function GopherOpenFileW; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'HttpAddRequestHeaders')]
function HttpAddRequestHeaders; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'HttpAddRequestHeadersA')]
function HttpAddRequestHeadersA; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'HttpAddRequestHeadersW')]
function HttpAddRequestHeadersW; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'HttpOpenRequest')]
function HttpOpenRequest(hConnect: HINTERNET; lpszVerb: string;
  lpszObjectName: string; lpszVersion: string; lpszReferrer: string;
  lplpszAcceptTypes: string; dwFlags: string;
  dwContext: DWORD): HINTERNET; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'HttpOpenRequest')]
function HttpOpenRequest(hConnect: HINTERNET; lpszVerb: string;
  lpszObjectName: string; lpszVersion: string; lpszReferrer: string;
  lplpszAcceptTypes: IntPtr; dwFlags: IntPtr;
  dwContext: DWORD): HINTERNET; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'HttpOpenRequest')]
function HttpOpenRequest(hConnect: HINTERNET; lpszVerb: string;
  lpszObjectName: string; lpszVersion: string; lpszReferrer: string;
  lplpszAcceptTypes: string; dwFlags: IntPtr;
  dwContext: DWORD): HINTERNET; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'HttpOpenRequest')]
function HttpOpenRequest(hConnect: HINTERNET; lpszVerb: string;
  lpszObjectName: string; lpszVersion: string; lpszReferrer: string;
  lplpszAcceptTypes: IntPtr; dwFlags: string;
  dwContext: DWORD): HINTERNET; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'HttpOpenRequestA')]
function HttpOpenRequestA; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'HttpOpenRequestW')]
function HttpOpenRequestW; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'HttpQueryInfo')]
function HttpQueryInfo; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'HttpQueryInfoA')]
function HttpQueryInfoA; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'HttpQueryInfoW')]
function HttpQueryInfoW; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'HttpSendRequest')]
function HttpSendRequest(hRequest: HINTERNET; lpszHeaders: string;
  dwHeadersLength: DWORD; lpOptional: IntPtr;
  dwOptionalLength: DWORD): BOOL; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'HttpSendRequest')]
function HttpSendRequest(hRequest: HINTERNET; lpszHeaders: IntPtr;
  dwHeadersLength: DWORD; lpOptional: IntPtr;
  dwOptionalLength: DWORD): BOOL; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'HttpSendRequestA')]
function HttpSendRequestA; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'HttpSendRequestW')]
function HttpSendRequestW; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'InternetCanonicalizeUrl')]
function InternetCanonicalizeUrl; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'InternetCanonicalizeUrlA')]
function InternetCanonicalizeUrlA; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'InternetCanonicalizeUrlW')]
function InternetCanonicalizeUrlW; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'InternetCloseHandle')]
function InternetCloseHandle; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'InternetCombineUrl')]
function InternetCombineUrl; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'InternetCombineUrlA')]
function InternetCombineUrlA; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'InternetCombineUrlW')]
function InternetCombineUrlW; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'InternetConfirmZoneCrossing')]
function InternetConfirmZoneCrossing; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'InternetConfirmZoneCrossingA')]
function InternetConfirmZoneCrossingA; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'InternetConfirmZoneCrossingW')]
function InternetConfirmZoneCrossingW; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'InternetConnect')]
function InternetConnect(hInet: HINTERNET; lpszServerName: string;
  nServerPort: INTERNET_PORT; lpszUsername: string; lpszPassword: string;
  dwService: DWORD; dwFlags: DWORD; dwContext: DWORD): HINTERNET; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'InternetConnect')]
function InternetConnect(hInet: HINTERNET; lpszServerName: string;
  nServerPort: INTERNET_PORT; lpszUsername: IntPtr; lpszPassword: IntPtr;
  dwService: DWORD; dwFlags: DWORD; dwContext: DWORD): HINTERNET; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'InternetConnect')]
function InternetConnect(hInet: HINTERNET; lpszServerName: string;
  nServerPort: INTERNET_PORT; lpszUsername: string; lpszPassword: IntPtr;
  dwService: DWORD; dwFlags: DWORD; dwContext: DWORD): HINTERNET; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'InternetConnect')]
function InternetConnect(hInet: HINTERNET; lpszServerName: string;
  nServerPort: INTERNET_PORT; lpszUsername: IntPtr; lpszPassword: string;
  dwService: DWORD; dwFlags: DWORD; dwContext: DWORD): HINTERNET; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'InternetConnectA')]
function InternetConnectA; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'InternetConnectW')]
function InternetConnectW; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'InternetCrackUrl')]
function InternetCrackUrl; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'InternetCrackUrlA')]
function InternetCrackUrlA; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'InternetCrackUrlW')]
function InternetCrackUrlW; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'InternetCreateUrl')]
function InternetCreateUrl; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'InternetCreateUrlA')]
function InternetCreateUrlA; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'InternetCreateUrlW')]
function InternetCreateUrlW; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'InternetErrorDlg')]
function InternetErrorDlg; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'InternetFindNextFile')]
function InternetFindNextFile(hFind: HINTERNET;
  out lpvFindData: TWin32FindData): BOOL; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'InternetFindNextFile')]
function InternetFindNextFile(hFind: HINTERNET;
  out lpvFindData: TGopherFindData): BOOL; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'InternetFindNextFileA')]
function InternetFindNextFileA; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'InternetFindNextFileW')]
function InternetFindNextFileW; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'InternetGetCookie')]
function InternetGetCookie; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'InternetGetCookieA')]
function InternetGetCookieA; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'InternetGetCookieW')]
function InternetGetCookieW; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'InternetGetLastResponseInfo')]
function InternetGetLastResponseInfo; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'InternetGetLastResponseInfoA')]
function InternetGetLastResponseInfoA; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'InternetGetLastResponseInfoW')]
function InternetGetLastResponseInfoW; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'InternetOpen')]
function InternetOpen(lpszAgent: string; dwAccessType: DWORD; lpszProxy: string;
  lpszProxyBypass: string; dwFlags: DWORD): HINTERNET; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'InternetOpen')]
function InternetOpen(lpszAgent: string; dwAccessType: DWORD; lpszProxy: IntPtr;
  lpszProxyBypass: IntPtr; dwFlags: DWORD): HINTERNET; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'InternetOpen')]
function InternetOpen(lpszAgent: string; dwAccessType: DWORD; lpszProxy: string;
  lpszProxyBypass: IntPtr; dwFlags: DWORD): HINTERNET; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'InternetOpen')]
function InternetOpen(lpszAgent: string; dwAccessType: DWORD; lpszProxy: IntPtr;
  lpszProxyBypass: string; dwFlags: DWORD): HINTERNET; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'InternetOpenA')]
function InternetOpenA; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'InternetOpenW')]
function InternetOpenW; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'InternetOpenUrl')]
function InternetOpenUrl; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'InternetOpenUrlA')]
function InternetOpenUrlA; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'InternetOpenUrlW')]
function InternetOpenUrlW; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'InternetQueryDataAvailable')]
function InternetQueryDataAvailable; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'InternetQueryOption')]
function InternetQueryOption; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'InternetQueryOptionA')]
function InternetQueryOptionA; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'InternetQueryOptionW')]
function InternetQueryOptionW; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'InternetReadFile')]
function InternetReadFile; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'InternetSetCookie')]
function InternetSetCookie; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'InternetSetCookieA')]
function InternetSetCookieA; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'InternetSetCookieW')]
function InternetSetCookieW; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'InternetSetFilePointer')]
function InternetSetFilePointer; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'InternetSetOption')]
function InternetSetOption(hInet: HINTERNET; dwOption: DWORD;
  lpBuffer: string; dwBufferLength: DWORD): BOOL; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'InternetSetOption')]
function InternetSetOption(hInet: HINTERNET; dwOption: DWORD;
  lpBuffer: IntPtr; dwBufferLength: DWORD): BOOL; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'InternetSetOptionA')]
function InternetSetOptionA; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'InternetSetOptionW')]
function InternetSetOptionW; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'InternetSetOptionEx')]
function InternetSetOptionEx(hInet: HINTERNET; dwOption: DWORD;
  lpBuffer: string; dwBufferLength, dwFlags: DWORD): BOOL; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'InternetSetOptionEx')]
function InternetSetOptionEx(hInet: HINTERNET; dwOption: DWORD;
  lpBuffer: IntPtr; dwBufferLength, dwFlags: DWORD): BOOL; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'InternetSetOptionExA')]
function InternetSetOptionExA; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'InternetSetOptionExW')]
function InternetSetOptionExW; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'InternetSetStatusCallback')]
function InternetSetStatusCallback; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'InternetTimeFromSystemTime')]
function InternetTimeFromSystemTime; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'InternetTimeFromSystemTimeA')]
function InternetTimeFromSystemTimeA; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'InternetTimeFromSystemTimeW')]
function InternetTimeFromSystemTimeW; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'InternetWriteFile')]
function InternetWriteFile; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'ReadUrlCacheEntryStream')]
function ReadUrlCacheEntryStream; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'RetrieveUrlCacheEntryFile')]
function RetrieveUrlCacheEntryFile; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'RetrieveUrlCacheEntryFileA')]
function RetrieveUrlCacheEntryFileA; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'RetrieveUrlCacheEntryFileW')]
function RetrieveUrlCacheEntryFileW; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'RetrieveUrlCacheEntryStream')]
function RetrieveUrlCacheEntryStream; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'RetrieveUrlCacheEntryStreamA')]
function RetrieveUrlCacheEntryStreamA; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'RetrieveUrlCacheEntryStreamW')]
function RetrieveUrlCacheEntryStreamW; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'SetUrlCacheEntryInfo')]
function SetUrlCacheEntryInfo; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetUrlCacheEntryInfoA')]
function SetUrlCacheEntryInfoA; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'SetUrlCacheEntryInfoW')]
function SetUrlCacheEntryInfoW; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'UnlockUrlCacheEntryFile')]
function UnlockUrlCacheEntryFile; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'UnlockUrlCacheEntryStream')]
function UnlockUrlCacheEntryStream; external;

[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CreateUrlCacheGroup')]
function CreateUrlCacheGroup; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'DeleteUrlCacheGroup')]
function DeleteUrlCacheGroup; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'FindFirstUrlCacheEntryEx')]
function FindFirstUrlCacheEntryEx; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'FindFirstUrlCacheEntryExA')]
function FindFirstUrlCacheEntryExA; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'FindFirstUrlCacheEntryExW')]
function FindFirstUrlCacheEntryExW; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'FindNextUrlCacheEntryEx')]
function FindNextUrlCacheEntryEx; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'FindNextUrlCacheEntryExA')]
function FindNextUrlCacheEntryExA; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'FindNextUrlCacheEntryExW')]
function FindNextUrlCacheEntryExW; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GetUrlCacheEntryInfoEx')]
function GetUrlCacheEntryInfoEx; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetUrlCacheEntryInfoExA')]
function GetUrlCacheEntryInfoExA; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'GetUrlCacheEntryInfoExW')]
function GetUrlCacheEntryInfoExW; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'HttpEndRequest')]
function HttpEndRequest; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'HttpEndRequestA')]
function HttpEndRequestA; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'HttpEndRequestW')]
function HttpEndRequestW; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'InternetAttemptConnect')]
function InternetAttemptConnect; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'InternetAuthNotifyCallback')]
function InternetAuthNotifyCallback; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'InternetAutodial')]
function InternetAutodial; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'InternetAutodialHangup')]
function InternetAutodialHangup; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'InternetCheckConnection')]
function InternetCheckConnection; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'InternetCheckConnectionA')]
function InternetCheckConnectionA; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'InternetCheckConnectionW')]
function InternetCheckConnectionW; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'InternetDial')]
function InternetDial; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'InternetGetConnectedState')]
function InternetGetConnectedState; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'InternetGoOnline')]
function InternetGoOnline; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'InternetGoOnlineA')]
function InternetGoOnlineA; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'InternetGoOnlineW')]
function InternetGoOnlineW; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'InternetHangUp')]
function InternetHangUp; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'InternetLockRequestFile')]
function InternetLockRequestFile; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'InternetReadFileEx')]
function InternetReadFileEx; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'InternetReadFileExA')]
function InternetReadFileExA; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'InternetReadFileExW')]
function InternetReadFileExW; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'InternetSetDialState')]
function InternetSetDialState; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'InternetUnlockRequestFile')]
function InternetUnlockRequestFile; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetUrlCacheEntryGroup')]
function SetUrlCacheEntryGroup; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'HttpSendRequestEx')]
function HttpSendRequestEx(hRequest: HINTERNET; const lpBuffersIn: TInternetBuffers;
  out lpBuffersOut: TInternetBuffers; dwFlags: DWORD; dwContext: DWORD): BOOL; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'HttpSendRequestEx')]
function HttpSendRequestEx(hRequest: HINTERNET; lpBuffersIn: IntPtr;
  lpBuffersOut: IntPtr; dwFlags: DWORD; dwContext: DWORD): BOOL; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'HttpSendRequestEx')]
function HttpSendRequestEx(hRequest: HINTERNET; const lpBuffersIn: TInternetBuffers;
  lpBuffersOut: IntPtr; dwFlags: DWORD; dwContext: DWORD): BOOL; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'HttpSendRequestEx')]
function HttpSendRequestEx(hRequest: HINTERNET; lpBuffersIn: IntPtr;
  out lpBuffersOut: TInternetBuffers; dwFlags: DWORD; dwContext: DWORD): BOOL; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'HttpSendRequestExA')]
function HttpSendRequestExA; external;
[SuppressUnmanagedCodeSecurity, DllImport(winetdll, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'HttpSendRequestExW')]
function HttpSendRequestExW; external;



function IS_GOPHER_FILE(GopherType: DWORD): BOOL;
begin
  Result := GopherType and GOPHER_TYPE_FILE_MASK = 0;
end;

function IS_GOPHER_DIRECTORY(GopherType: DWORD): BOOL;
begin
  Result := GopherType and GOPHER_TYPE_DIRECTORY = 0;
end;

function IS_GOPHER_PHONE_SERVER(GopherType: DWORD): BOOL;
begin
  Result := GopherType and GOPHER_TYPE_CSO = 0;
end;

function IS_GOPHER_ERROR(GopherType: DWORD): BOOL;
begin
  Result := GopherType and GOPHER_TYPE_ERROR = 0;
end;

function IS_GOPHER_INDEX_SERVER(GopherType: DWORD): BOOL;
begin
  Result := GopherType and GOPHER_TYPE_INDEX_SERVER = 0;
end;

function IS_GOPHER_TELNET_SESSION(GopherType: DWORD): BOOL;
begin
  Result := GopherType and GOPHER_TYPE_TELNET = 0;
end;

function IS_GOPHER_BACKUP_SERVER(GopherType: DWORD): BOOL;
begin
  Result := GopherType and GOPHER_TYPE_REDUNDANT = 0;
end;

function IS_GOPHER_TN3270_SESSION(GopherType: DWORD): BOOL;
begin
  Result := GopherType and GOPHER_TYPE_TN3270 = 0;
end;

function IS_GOPHER_ASK(GopherType: DWORD): BOOL;
begin
  Result := GopherType and GOPHER_TYPE_ASK = 0;
end;

function IS_GOPHER_PLUS(GopherType: DWORD): BOOL;
begin
  Result := GopherType and GOPHER_TYPE_GOPHER_PLUS = 0;
end;

function IS_GOPHER_TYPE_KNOWN(GopherType: DWORD): BOOL;
begin
  Result := GopherType and GOPHER_TYPE_UNKNOWN = 0;
end;

end.
